/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.json;

import de.iip_ecosphere.platform.support.json.IOIterator;
import de.iip_ecosphere.platform.support.json.JsonArrayBuilder;
import de.iip_ecosphere.platform.support.json.JsonGenerator;
import de.iip_ecosphere.platform.support.json.JsonIterator;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonObjectBuilder;
import de.iip_ecosphere.platform.support.json.JsonProviderDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Json {
    private static Json prototype = PluginManager.getPluginInstance(Json.class, JsonProviderDescriptor.class);

    public static Json createInstance() {
        return prototype.createInstanceImpl(false);
    }

    public static Json createInstance4All() {
        return prototype.createInstanceImpl(true);
    }

    public static Json createInstance(Class<?> cls) {
        return prototype.createInstanceImpl(false).configureFor(cls);
    }

    public static Json createInstance(Class<?> ... cls) {
        Json result = prototype.createInstanceImpl(false);
        for (Class<?> c : cls) {
            result.configureFor(c);
        }
        return result;
    }

    public static void setPrototype(Json json) {
        if (null != json) {
            prototype = json;
        }
    }

    protected abstract Json createInstanceImpl(boolean var1);

    public abstract String toJson(Object var1) throws IOException;

    public String toJsonQuiet(Object obj) {
        String result;
        try {
            result = this.toJson(obj);
        }
        catch (IOException e) {
            result = "";
        }
        return result;
    }

    public abstract <R> R fromJson(Object var1, Class<R> var2) throws IOException;

    public abstract <R> List<R> listFromJson(Object var1, Class<R> var2);

    public abstract <K, V> Map<K, V> mapFromJson(Object var1, Class<K> var2, Class<V> var3);

    public abstract <T> T readValue(String var1, Class<T> var2) throws IOException;

    public static <T> T readValueDflt(String src, Class<T> cls) throws IOException {
        return prototype.readValue(src, cls);
    }

    public abstract <T> T readValue(byte[] var1, Class<T> var2) throws IOException;

    public static <T> T readValueDflt(byte[] src, Class<T> cls) throws IOException {
        return prototype.readValue(src, cls);
    }

    public abstract byte[] writeValueAsBytes(Object var1) throws IOException;

    public abstract String writeValueAsString(Object var1) throws IOException;

    public abstract <T> T convertValue(Object var1, Class<T> var2) throws IllegalArgumentException;

    public static String toJsonDflt(Object obj) throws IOException {
        return prototype.toJson(obj);
    }

    public static <R> R fromJsonDflt(Object json, Class<R> cls) throws IOException {
        return prototype.fromJson(json, cls);
    }

    public static <R> List<R> listFromJsonDflt(Object json, Class<R> cls) {
        return prototype.listFromJson(json, cls);
    }

    public static <K, V> Map<K, V> mapFromJsonDflt(Object json, Class<K> keyCls, Class<V> valueCls) {
        return prototype.mapFromJson(json, keyCls, valueCls);
    }

    public static byte[] writeValueAsBytesDflt(Object value) throws IOException {
        return prototype.writeValueAsBytes(value);
    }

    public static String writeValueAsStringDflt(Object value) throws IOException {
        return prototype.writeValueAsString(value);
    }

    public abstract void writeValue(File var1, Object var2) throws IOException;

    public abstract void writeValue(OutputStream var1, Object var2) throws IOException;

    public abstract Json configureFor(Class<?> var1);

    public abstract Json handleIipDataClasses();

    public abstract Json defineOptionals(Class<?> var1, String ... var2);

    public abstract Json defineFields(String ... var1);

    public abstract Json exceptFields(String ... var1);

    public abstract Json configureExceptFieldsFilter(String var1, String ... var2);

    public abstract Json filterAllExceptFields(String ... var1);

    public abstract Json failOnUnknownProperties(boolean var1);

    public <T> EnumMapping<T> createEnumMapping(Class<T> type) {
        return this.createEnumMapping(type, null);
    }

    public abstract <T> EnumMapping<T> createEnumMapping(Class<T> var1, Map<String, T> var2);

    public <T extends Enum<T>> EnumMapping<T> createEnumValueMapping(Class<T> type) {
        return this.createEnumMapping(type, Json.createEnumValueMap(type));
    }

    public abstract Json declareEnums(EnumMapping<?> ... var1);

    public static <T extends Enum<T>> Map<String, T> createEnumValueMap(Class<? extends T> enm) {
        HashMap<String, Enum> result = new HashMap<String, Enum>();
        if (enm.isEnum()) {
            for (Enum c : (Enum[])enm.getEnumConstants()) {
                result.put(c.name(), c);
            }
        }
        return result;
    }

    public abstract Json configureLazy(Set<Object> var1);

    public abstract <T> IOIterator<T> createIterator(InputStream var1, Class<T> var2) throws IOException;

    public static JsonObject createObject(String string) throws IOException {
        return Json.createObject(new StringReader(string));
    }

    public static JsonObject createObject(byte[] data) throws IOException {
        return Json.createObject(new InputStreamReader(new ByteArrayInputStream(data)));
    }

    public static JsonObject createObject(Reader reader) throws IOException {
        return prototype.createObjectImpl(reader);
    }

    protected abstract JsonObject createObjectImpl(Reader var1) throws IOException;

    public static JsonObjectBuilder createObjectBuilder() {
        return prototype.createObjectBuilderImpl();
    }

    protected abstract JsonObjectBuilder createObjectBuilderImpl();

    public static JsonArrayBuilder createArrayBuilder() {
        return prototype.createArrayBuilderImpl();
    }

    protected abstract JsonArrayBuilder createArrayBuilderImpl();

    protected abstract JsonIterator parseImpl(String var1);

    protected abstract JsonIterator parseImpl(byte[] var1);

    public static JsonIterator parse(String text) {
        return prototype.parseImpl(text);
    }

    public static JsonIterator parse(byte[] data) {
        return prototype.parseImpl(data);
    }

    protected abstract JsonGenerator createGeneratorImpl(Writer var1) throws IOException;

    public static JsonGenerator createGenerator(Writer writer) throws IOException {
        return prototype.createGeneratorImpl(writer);
    }

    public static interface EnumMapping<T> {
        public void addMapping(String var1, T var2);

        public Class<T> getType();
    }
}

