/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.plugins;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.ChildFirstClassLoader;
import de.iip_ecosphere.platform.support.plugins.ChildFirstIndexedClassloader;
import de.iip_ecosphere.platform.support.plugins.ChildFirstURLClassLoader;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;

public class URLPluginSetupDescriptor
implements PluginSetupDescriptor {
    private URL[] urls;

    public URLPluginSetupDescriptor(URL[] urls) {
        this.urls = urls;
    }

    public static URL[] toURL(String ... urls) throws IllegalArgumentException {
        URL[] result = new URL[urls.length];
        for (int u = 0; u < urls.length; ++u) {
            result[u] = NetUtils.createURL(urls[u]);
        }
        return result;
    }

    public static URL[] toURLSafe(String ... urls) {
        URL[] result;
        try {
            result = URLPluginSetupDescriptor.toURL(urls);
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(URLPluginSetupDescriptor.class).error("While converting URLs {}: {} Ignoring.", (Object)urls, (Object)e.getMessage());
            result = new URL[]{};
        }
        return result;
    }

    public static URL[] toURL(File ... files) throws MalformedURLException {
        URL[] result = new URL[files.length];
        for (int u = 0; u < files.length; ++u) {
            result[u] = files[u].toURI().toURL();
        }
        return result;
    }

    public static URL[] toURLSafe(File ... files) {
        URL[] result;
        try {
            result = URLPluginSetupDescriptor.toURL(files);
        }
        catch (MalformedURLException e) {
            LoggerFactory.getLogger(URLPluginSetupDescriptor.class).error("While converting URLs {}: {} Ignoring.", (Object)files, (Object)e.getMessage());
            result = new URL[]{};
        }
        return result;
    }

    @Override
    public ClassLoader createClassLoader(ClassLoader parent) {
        LoggerFactory.getLogger(URLPluginSetupDescriptor.class).debug("Creating classpath for {}", (Object)Arrays.toString(this.urls));
        return this.createClassLoader(this.urls, parent);
    }

    protected ClassLoader createClassLoader(URL[] urls, ClassLoader parent) {
        ClassLoader result = null;
        if (ChildFirstClassLoader.useChildFirst()) {
            File idxFile = this.getIndexFile();
            if (null != idxFile) {
                try {
                    result = new ChildFirstIndexedClassloader(idxFile, parent);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(URLPluginSetupDescriptor.class).warn("Cannot create {}, falling back to {}. Reason: {}", ChildFirstIndexedClassloader.class.getSimpleName(), ChildFirstURLClassLoader.class.getSimpleName(), e.getMessage());
                }
            }
            if (null == result) {
                result = new ChildFirstURLClassLoader(urls, parent);
            }
        } else {
            result = new URLClassLoader(urls, parent);
        }
        return result;
    }

    protected File getIndexFile() {
        return null;
    }

    protected URL[] getURLs() {
        return this.urls;
    }
}

