/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.resources;

import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OktoflowResourceResolver
implements ResourceResolver {
    private File base;
    private String folder;

    public OktoflowResourceResolver() {
        this(new File(""), null);
    }

    public OktoflowResourceResolver(File base) {
        this(base, null);
    }

    public OktoflowResourceResolver(File base, String folder) {
        this.base = base;
        this.folder = folder;
    }

    @Override
    public String getName() {
        return "oktoflow resources";
    }

    @Override
    public InputStream resolve(ClassLoader loader, String resource) {
        InputStream result = this.resolve(loader, resource, new File(this.base, "resources.ipr"));
        if (null == result) {
            result = this.resolve(loader, resource, new File(this.base, "resources"));
        }
        return result;
    }

    private InputStream resolve(ClassLoader loader, String resource, File baseFolder) {
        File[] folders;
        FileInputStream result = null;
        if (baseFolder.isDirectory() && null != (folders = null != this.folder ? new File[]{new File(baseFolder, this.folder)} : baseFolder.listFiles())) {
            for (File fo : folders) {
                if (fo.isDirectory()) {
                    File f = new File(fo, resource);
                    if (!f.exists()) continue;
                    try {
                        result = new FileInputStream(f);
                        break;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                if (!fo.getName().equals(resource)) continue;
                try {
                    result = new FileInputStream(fo);
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result;
    }
}

