/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.query;

import com.google.common.collect.ImmutableMap;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.model.Domain;
import org.apache.qpid.server.query.engine.parsing.expression.literal.ConstantExpression;
import org.apache.qpid.server.query.engine.parsing.factory.AccessorExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.ProjectionExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.query.ProjectionExpression;
import org.apache.qpid.server.query.engine.parsing.query.QueryExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;
import org.apache.qpid.server.query.engine.retriever.AclRuleRetriever;
import org.apache.qpid.server.query.engine.retriever.BindingRetriever;
import org.apache.qpid.server.query.engine.retriever.CertificateRetriever;
import org.apache.qpid.server.query.engine.retriever.ConfiguredObjectRetriever;
import org.apache.qpid.server.query.engine.retriever.ConnectionLimitRuleRetriever;
import org.apache.qpid.server.query.engine.retriever.DomainRetriever;
import org.apache.qpid.server.query.engine.retriever.EntityRetriever;
import org.apache.qpid.server.query.engine.retriever.SessionRetriever;
import org.apache.qpid.server.security.access.plugins.AclRule;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRule;

public class FromExpression<T, R extends Stream<?>, C extends ConfiguredObject<?>>
extends ConstantExpression<T, R> {
    private final ConfiguredObjectRetriever<C> _configuredObjectRetriever = new ConfiguredObjectRetriever();
    private final EntityRetriever<C> _aclRuleRetriever = new AclRuleRetriever();
    private final EntityRetriever<C> _bindingRetriever = new BindingRetriever();
    private final EntityRetriever<C> _certificateRetriever = new CertificateRetriever();
    private final EntityRetriever<C> _connectionLimitRuleRetriever = new ConnectionLimitRuleRetriever();
    private final EntityRetriever<C> _domainRetriever = new DomainRetriever();
    private final EntityRetriever<C> _sessionRetriever = new SessionRetriever();
    private final Map<Class<?>, EntityRetriever<C>> _allowedClasses = ImmutableMap.builder().put(AclRule.class, this._aclRuleRetriever).put(Binding.class, this._bindingRetriever).put(Certificate.class, this._certificateRetriever).put(ConnectionLimitRule.class, this._connectionLimitRuleRetriever).put(Domain.class, this._domainRetriever).put(Session.class, this._sessionRetriever).build();
    private final String _domain;
    private final String _alias;
    private Class<?> _category;
    private Broker<?> _broker;

    public FromExpression(String domain, String alias) {
        super(null);
        this._domain = domain;
        this._alias = alias;
    }

    @Override
    public R get() {
        this._broker = (Broker)this.ctx().get("broker");
        if (Objects.equals(this._domain, "broker")) {
            return (R)Stream.of(this._broker);
        }
        if (this.ctx().contains(this._domain)) {
            QueryExpression query = (QueryExpression)this.ctx().get(this._domain);
            return (R)((Stream)query.getSelect().apply(null));
        }
        this._category = this.getDomainClass();
        if (this._allowedClasses.containsKey(this._category)) {
            if (this._category.isAssignableFrom(Domain.class)) {
                return (R)Stream.concat(this._allowedClasses.keySet().stream().map(type -> ImmutableMap.builder().put((Object)"name", (Object)type.getSimpleName()).build()), this._allowedClasses.get(this._category).retrieve(this._broker));
            }
            return (R)this._allowedClasses.get(this._category).retrieve(this._broker);
        }
        return (R)this._configuredObjectRetriever.retrieve(this._broker, this._category);
    }

    private Class<?> getDomainClass() {
        Model brokerModel = this._broker.getModel();
        return Stream.concat(this._allowedClasses.keySet().stream(), brokerModel.getSupportedCategories().stream()).filter(type -> this._domain.equalsIgnoreCase(type.getSimpleName())).findFirst().orElseThrow(() -> QueryParsingException.of("Querying from '%s' not supported", this._domain));
    }

    public List<String> getFieldNames() {
        if (Objects.equals(this._domain, "broker")) {
            return new ArrayList<String>(this._broker.getModel().getTypeRegistry().getAttributeNames(Broker.class));
        }
        if (this.ctx().contains(this._domain)) {
            QueryExpression query = (QueryExpression)this.ctx().get(this._domain);
            return query.getSelect().getProjections().stream().map(ProjectionExpression::getAlias).collect(Collectors.toList());
        }
        if (this._allowedClasses.containsKey(this._category)) {
            return this._allowedClasses.get(this._category).getFieldNames();
        }
        return Stream.concat(this._broker.getModel().getTypeRegistry().getAttributeNames(this._category).stream(), Stream.of("statistics")).collect(Collectors.toList());
    }

    public <Y> List<ProjectionExpression<T, Y>> getProjections(List<String> aliases, SelectExpression<T, R> selectExpression) {
        return aliases.stream().map(name -> AccessorExpressionFactory.delegating(name, name)).map(expression -> ProjectionExpressionFactory.projection(expression, expression.getAlias(), selectExpression.getOrdinal())).collect(Collectors.toList());
    }

    @Override
    public String getAlias() {
        if (this._alias == null) {
            return this._domain;
        }
        return this._alias;
    }

    @Override
    public String toString() {
        return this._domain;
    }
}

