/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.mimecontentconverter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.message.mimecontentconverter.IdentityConverter;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentToObjectConverter;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeContentConverterRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeContentConverterRegistry.class);
    private static final Map<String, MimeContentToObjectConverter> _mimeContentToObjectConverters;
    private static final Multimap<Class, ObjectToMimeContentConverter> _classToMimeContentConverters;

    private static Multimap<Class, ObjectToMimeContentConverter> buildClassToMimeConverters() {
        HashMultimap classToMineConverters = HashMultimap.create();
        Iterable<ObjectToMimeContentConverter> objectToMimeContentConverters = new QpidServiceLoader().instancesOf(ObjectToMimeContentConverter.class);
        for (ObjectToMimeContentConverter converter : objectToMimeContentConverters) {
            Class objectClass = converter.getObjectClass();
            for (ObjectToMimeContentConverter existing : classToMineConverters.get(objectClass)) {
                if (existing.getRank() != converter.getRank()) continue;
                LOGGER.warn("MIME converter for object class {} has two or more implementations with the same rank {}. It is undefined which one will be used. Implementations are: {} {} ", new Object[]{existing.getObjectClass().getName(), existing.getRank(), existing.getClass().getName(), converter.getClass().getName()});
            }
            classToMineConverters.put(objectClass, (Object)converter);
        }
        classToMineConverters.put(Void.class, (Object)new IdentityConverter());
        return ImmutableMultimap.copyOf((Multimap)classToMineConverters);
    }

    private static Map<String, MimeContentToObjectConverter> buildMimeContentToObjectMap() {
        HashMap<String, MimeContentToObjectConverter> mimeContentToObjectConverters = new HashMap<String, MimeContentToObjectConverter>();
        for (MimeContentToObjectConverter converter : new QpidServiceLoader().instancesOf(MimeContentToObjectConverter.class)) {
            String mimeType = converter.getMimeType();
            MimeContentToObjectConverter existing = mimeContentToObjectConverters.put(mimeType, converter);
            if (existing == null) continue;
            LOGGER.warn("MIME converter {} for mime type '{}' replaced by {}.", new Object[]{existing.getClass().getName(), existing.getMimeType(), converter.getClass().getName()});
        }
        return Collections.unmodifiableMap(mimeContentToObjectConverters);
    }

    public static MimeContentToObjectConverter getMimeContentToObjectConverter(String mimeType) {
        return _mimeContentToObjectConverters.get(mimeType);
    }

    public static ObjectToMimeContentConverter getBestFitObjectToMimeContentConverter(Object object) {
        ObjectToMimeContentConverter converter = null;
        if (object != null) {
            ArrayList classes = new ArrayList(Arrays.asList(object.getClass().getInterfaces()));
            classes.add(object.getClass());
            for (Class clazz : classes) {
                for (ObjectToMimeContentConverter candidate : _classToMimeContentConverters.get((Object)clazz)) {
                    if (!candidate.isAcceptable(object) || converter != null && candidate.getRank() <= converter.getRank()) continue;
                    converter = candidate;
                }
            }
        }
        return converter;
    }

    public static ObjectToMimeContentConverter getBestFitObjectToMimeContentConverter(Object object, Class<?> typeHint) {
        ObjectToMimeContentConverter converter = null;
        for (ObjectToMimeContentConverter candidate : _classToMimeContentConverters.get(typeHint)) {
            if (!candidate.isAcceptable(object) || converter != null && candidate.getRank() <= converter.getRank()) continue;
            converter = candidate;
        }
        return converter;
    }

    static {
        _classToMimeContentConverters = MimeContentConverterRegistry.buildClassToMimeConverters();
        _mimeContentToObjectConverters = MimeContentConverterRegistry.buildMimeContentToObjectMap();
    }
}

