/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.preferences;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.preferences.Preference;
import org.apache.qpid.server.model.preferences.PreferenceValue;

public class PreferenceImpl
implements Preference {
    private final String _name;
    private final String _description;
    private final Set<Principal> _visibilitySet;
    private final PreferenceValue _preferenceValue;
    private final UUID _id;
    private final Principal _owner;
    private final ConfiguredObject<?> _associatedObject;
    private final String _type;
    private final Date _lastUpdatedDate;
    private final Date _createdDate;

    public PreferenceImpl(ConfiguredObject<?> associatedObject, UUID uuid, String name, String type, String description, Principal owner, Date lastUpdatedDate, Date createdDate, Set<Principal> visibilitySet, PreferenceValue preferenceValue) {
        if (associatedObject == null) {
            throw new IllegalArgumentException("Preference associatedObject is mandatory");
        }
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Preference name is mandatory");
        }
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("Preference type is mandatory");
        }
        this._lastUpdatedDate = lastUpdatedDate == null ? null : new Date(lastUpdatedDate.getTime());
        this._createdDate = createdDate == null ? null : new Date(createdDate.getTime());
        this._associatedObject = associatedObject;
        this._id = uuid;
        this._name = name;
        this._type = type;
        this._description = description;
        this._owner = owner;
        this._visibilitySet = visibilitySet == null ? ImmutableSet.of() : ImmutableSet.copyOf(visibilitySet);
        this._preferenceValue = preferenceValue;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public Principal getOwner() {
        return this._owner;
    }

    @Override
    public ConfiguredObject<?> getAssociatedObject() {
        return this._associatedObject;
    }

    @Override
    public Set<Principal> getVisibilityList() {
        return this._visibilitySet;
    }

    @Override
    public Date getLastUpdatedDate() {
        return new Date(this._lastUpdatedDate.getTime());
    }

    @Override
    public Date getCreatedDate() {
        return new Date(this._createdDate.getTime());
    }

    @Override
    public PreferenceValue getValue() {
        return this._preferenceValue;
    }

    @Override
    public Map<String, Object> getAttributes() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this._id);
        map.put("name", this._name);
        map.put("type", this._type);
        map.put("description", this._description);
        map.put("owner", this._owner);
        map.put("associatedObject", this._associatedObject.getId());
        map.put("visibilityList", this.getVisibilityList());
        map.put("lastUpdatedDate", this.getLastUpdatedDate());
        map.put("createdDate", this.getCreatedDate());
        map.put("value", this._preferenceValue.getAttributes());
        return map;
    }
}

