/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AbstractScramAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.CompositeUsernamePasswordAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.ManagedUser;
import org.apache.qpid.server.security.auth.manager.UsernamePasswordAuthenticationProvider;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5Base64HashedNegotiator;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5Base64HexNegotiator;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5Negotiator;
import org.apache.qpid.server.security.auth.sasl.plain.PlainNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSource;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSourceAdapter;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeUsernamePasswordAuthenticationManagerImpl
extends AbstractAuthenticationManager<CompositeUsernamePasswordAuthenticationManagerImpl>
implements CompositeUsernamePasswordAuthenticationManager<CompositeUsernamePasswordAuthenticationManagerImpl> {
    public static final String MECHANISM_NAME = "COMPOSITE";
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeUsernamePasswordAuthenticationManagerImpl.class);
    @ManagedAttributeField
    private List<String> _delegates;
    private final Set<UsernamePasswordAuthenticationProvider<?>> _authenticationProviders = new LinkedHashSet();
    private final Map<String, Function<SaslSettings, SaslNegotiator>> _saslNegotiators = new HashMap<String, Function<SaslSettings, SaslNegotiator>>();
    private final Map<String, ScramSaslServerSourceAdapter> _scramAdapters = new HashMap<String, ScramSaslServerSourceAdapter>();
    private final Map<String, String> _hmacNames = new HashMap<String, String>();
    private final Map<String, String> _digestNames = new HashMap<String, String>();
    private List<String> _mechanisms = new ArrayList<String>();
    private List<String> _secureOnlyMechanisms = new ArrayList<String>();
    private List<String> _disabledMechanisms = new ArrayList<String>();
    final int scramIterationCount = this.getContextValue(Integer.class, "qpid.auth.scram.iteration_count");

    @ManagedObjectFactoryConstructor
    public CompositeUsernamePasswordAuthenticationManagerImpl(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        PasswordSource passwordSource = this.getPasswordSource();
        this._scramAdapters.put("SCRAM-SHA-1", new ScramSaslServerSourceAdapter(this.scramIterationCount, "HmacSHA1", "SHA-1", passwordSource));
        this._scramAdapters.put("SCRAM-SHA-256", new ScramSaslServerSourceAdapter(this.scramIterationCount, "HmacSHA256", "SHA-256", passwordSource));
        if (new HashSet<String>(this._delegates).size() != this._delegates.size()) {
            throw new IllegalConfigurationException("Composite authentication manager shouldn't contain duplicate names");
        }
        for (String delegate : this._delegates) {
            AuthenticationProvider<?> authProvider2 = this.resolveDelegate(delegate);
            this._authenticationProviders.add((UsernamePasswordAuthenticationProvider)authProvider2);
        }
        if (this._authenticationProviders.isEmpty()) {
            throw new IllegalConfigurationException("Composite authentication manager should contain at least one delegate");
        }
        this._mechanisms = new ArrayList<String>(((UsernamePasswordAuthenticationProvider)this._authenticationProviders.stream().findFirst().get()).getMechanisms());
        this._authenticationProviders.forEach(authProvider -> this._mechanisms.retainAll(authProvider.getMechanisms()));
        this._authenticationProviders.stream().filter(authProvider -> authProvider.getDisabledMechanisms() != null).forEach(authProvider -> this._mechanisms.removeAll(authProvider.getDisabledMechanisms()));
        this._secureOnlyMechanisms = Stream.concat(Optional.ofNullable(super.getSecureOnlyMechanisms()).orElse(Collections.emptyList()).stream(), this._authenticationProviders.stream().filter(authProvider -> authProvider.getSecureOnlyMechanisms() != null).flatMap(authProvider -> authProvider.getSecureOnlyMechanisms().stream())).distinct().collect(Collectors.toList());
        this._disabledMechanisms = Stream.concat(Optional.ofNullable(super.getDisabledMechanisms()).orElse(Collections.emptyList()).stream(), this._authenticationProviders.stream().filter(authProvider -> authProvider.getDisabledMechanisms() != null).flatMap(authProvider -> authProvider.getDisabledMechanisms().stream())).distinct().collect(Collectors.toList());
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._hmacNames.put("SCRAM-SHA-1", "HmacSHA1");
        this._hmacNames.put("SCRAM-SHA-256", "HmacSHA256");
        this._digestNames.put("SCRAM-SHA-1", "SHA-1");
        this._digestNames.put("SCRAM-SHA-256", "SHA-256");
        this._saslNegotiators.put("CRAM-MD5", saslSettings -> new CramMd5Negotiator(this.getAuthenticationProviderStub(), saslSettings.getLocalFQDN(), this.getPasswordSource()));
        this._saslNegotiators.put("CRAM-MD5-HASHED", saslSettings -> new CramMd5Base64HashedNegotiator(this.getAuthenticationProviderStub(), saslSettings.getLocalFQDN(), this.getPasswordSource()));
        this._saslNegotiators.put("CRAM-MD5-HEX", saslSettings -> new CramMd5Base64HexNegotiator(this.getAuthenticationProviderStub(), saslSettings.getLocalFQDN(), this.getPasswordSource()));
        this._saslNegotiators.put("PLAIN", saslSettings -> new PlainNegotiator(this));
        this._saslNegotiators.put("SCRAM-SHA-1", saslSettings -> new ScramNegotiator(this, this.getScramSaslServerSource("SCRAM-SHA-1"), "SCRAM-SHA-1"));
        this._saslNegotiators.put("SCRAM-SHA-256", saslSettings -> new ScramNegotiator(this, this.getScramSaslServerSource("SCRAM-SHA-256"), "SCRAM-SHA-256"));
    }

    @Override
    public void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        Collection delegates = (Collection)proxyForValidation.getAttribute("delegates");
        if (delegates.isEmpty()) {
            throw new IllegalConfigurationException("Composite authentication manager should contain at least one delegate");
        }
        delegates.forEach(this::resolveDelegate);
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.unmodifiableList(this._mechanisms);
    }

    @Override
    public List<String> getAvailableMechanisms(boolean secure) {
        List result = this._mechanisms.stream().filter(mechanism -> secure || !this._secureOnlyMechanisms.contains(mechanism)).filter(mechanism -> !this._disabledMechanisms.contains(mechanism)).collect(Collectors.toList());
        return Collections.unmodifiableList(result);
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        return this._saslNegotiators.getOrDefault(mechanism, settings -> null).apply(saslSettings);
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        for (UsernamePasswordAuthenticationProvider<?> authenticationProvider : this._authenticationProviders) {
            AuthenticationResult authResult = authenticationProvider.authenticate(username, password);
            if (AuthenticationResult.AuthenticationStatus.ERROR.equals((Object)authResult.getStatus())) {
                LOGGER.debug("Authentication of user '{}' against '{}' failed", (Object)username, (Object)authenticationProvider.getClass().getSimpleName());
                continue;
            }
            LOGGER.debug("Authentication of user '{}' against '{}' succeeded", (Object)username, (Object)authenticationProvider.getClass().getSimpleName());
            return authResult;
        }
        LOGGER.debug("All authentication attempts failed");
        return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
    }

    private ScramSaslServerSource getScramSaslServerSource(final String mechanism) {
        return new ScramSaslServerSource(){

            @Override
            public int getIterationCount() {
                return CompositeUsernamePasswordAuthenticationManagerImpl.this.scramIterationCount;
            }

            @Override
            public String getDigestName() {
                return Optional.ofNullable(CompositeUsernamePasswordAuthenticationManagerImpl.this._digestNames.get(mechanism)).orElseThrow(() -> new ConnectionScopedRuntimeException("Mechanism '" + mechanism + "' not supported"));
            }

            @Override
            public String getHmacName() {
                return Optional.ofNullable(CompositeUsernamePasswordAuthenticationManagerImpl.this._hmacNames.get(mechanism)).orElseThrow(() -> new ConnectionScopedRuntimeException("Mechanism '" + mechanism + "' not supported"));
            }

            @Override
            public ScramSaslServerSource.SaltAndPasswordKeys getSaltAndPasswordKeys(String username) {
                return CompositeUsernamePasswordAuthenticationManagerImpl.this._authenticationProviders.stream().filter(authProvider -> authProvider instanceof ConfigModelPasswordManagingAuthenticationProvider).filter(authProvider -> ((ConfigModelPasswordManagingAuthenticationProvider)authProvider).getUser(username) != null).findFirst().map(authProvider -> {
                    if (authProvider instanceof AbstractScramAuthenticationManager) {
                        return ((AbstractScramAuthenticationManager)authProvider).getSaltAndPasswordKeys(username);
                    }
                    return CompositeUsernamePasswordAuthenticationManagerImpl.this._scramAdapters.get(mechanism).getSaltAndPasswordKeys(username);
                }).orElse(CompositeUsernamePasswordAuthenticationManagerImpl.this._scramAdapters.get(mechanism).getSaltAndPasswordKeys(username));
            }
        };
    }

    private AuthenticationProvider<?> resolveDelegate(String delegate) {
        Broker broker = (Broker)this.getParent();
        Optional<AuthenticationProvider> optAuthProvider = broker.getAuthenticationProviders().stream().filter(provider -> provider.getName().equals(delegate)).findFirst();
        if (!optAuthProvider.isPresent()) {
            throw new IllegalConfigurationException("Authentication provider '" + delegate + "' not found");
        }
        AuthenticationProvider authProvider = optAuthProvider.get();
        if (!(authProvider instanceof UsernamePasswordAuthenticationProvider)) {
            throw new IllegalConfigurationException("Authentication provider '" + delegate + "' is not UsernamePasswordAuthenticationProvider");
        }
        if (authProvider instanceof CompositeUsernamePasswordAuthenticationManager) {
            throw new IllegalConfigurationException("Composite authentication providers shouldn't be nested");
        }
        return authProvider;
    }

    private PasswordSource getPasswordSource() {
        return username -> this._authenticationProviders.stream().filter(authProvider -> authProvider instanceof ConfigModelPasswordManagingAuthenticationProvider).filter(authProvider -> ((ConfigModelPasswordManagingAuthenticationProvider)authProvider).getUser(username) != null).findFirst().map(authProvider -> ((ConfigModelPasswordManagingAuthenticationProvider)authProvider).getPasswordSource().getPassword(username)).orElse(null);
    }

    private <X extends ConfigModelPasswordManagingAuthenticationProvider<X>> ConfigModelPasswordManagingAuthenticationProvider<X> getAuthenticationProviderStub() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", "AuthenticationProviderStub");
        attributes.put("id", UUID.randomUUID());
        final CompositeUsernamePasswordAuthenticationManagerImpl parent = this;
        final PasswordSource passwordSource = this.getPasswordSource();
        return new ConfigModelPasswordManagingAuthenticationProvider<X>(attributes, (Container)this.getParent()){

            @Override
            public AuthenticationResult authenticate(String username, String password) {
                return parent.authenticate(username, password);
            }

            @Override
            public PasswordSource getPasswordSource() {
                return passwordSource;
            }

            @Override
            protected String createStoredPassword(String password) {
                throw new ConnectionScopedRuntimeException("SaslNegotiator isn't supposed to call createStoredPassword()");
            }

            @Override
            void validateUser(ManagedUser managedUser) {
                throw new ConnectionScopedRuntimeException("SaslNegotiator isn't supposed to call validateUser()");
            }

            @Override
            public List<String> getMechanisms() {
                throw new ConnectionScopedRuntimeException("SaslNegotiator isn't supposed to call getMechanisms()");
            }

            @Override
            public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
                throw new ConnectionScopedRuntimeException("SaslNegotiator isn't supposed to call createSaslNegotiator()");
            }
        };
    }

    @Override
    public String toString() {
        return "CompositeAuthenticationManagerImpl {_authenticationProviders=" + this._authenticationProviders + "}";
    }

    @Override
    public List<String> getDelegates() {
        return this._delegates;
    }
}

