/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.Xid;
import org.apache.qpid.server.util.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtxBranch {
    private static final Logger LOGGER = LoggerFactory.getLogger(DtxBranch.class);
    private final Xid _xid;
    private final List<ServerTransaction.Action> _postTransactionActions = new ArrayList<ServerTransaction.Action>();
    private final Map<AMQPSession<?, ?>, State> _associatedSessions = new HashMap();
    private final List<EnqueueRecord> _enqueueRecords = new ArrayList<EnqueueRecord>();
    private final List<DequeueRecord> _dequeueRecords = new ArrayList<DequeueRecord>();
    private final DtxRegistry _dtxRegistry;
    private State _state = State.ACTIVE;
    private long _timeout;
    private Transaction _transaction;
    private long _expiration;
    private ScheduledFuture<?> _timeoutFuture;
    private Transaction.StoredXidRecord _storedXidRecord;

    public DtxBranch(Xid xid, DtxRegistry dtxRegistry) {
        this._xid = xid;
        this._dtxRegistry = dtxRegistry;
    }

    public DtxBranch(Transaction.StoredXidRecord storedXidRecord, DtxRegistry dtxRegistry) {
        this(new Xid(storedXidRecord.getFormat(), storedXidRecord.getGlobalId(), storedXidRecord.getBranchId()), dtxRegistry);
        this._storedXidRecord = storedXidRecord;
    }

    public Xid getXid() {
        return this._xid;
    }

    public State getState() {
        return this._state;
    }

    public void setState(State state) {
        this._state = state;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        LOGGER.debug("Setting timeout to {}s for DtxBranch {}", (Object)timeout, (Object)this._xid);
        if (this._timeoutFuture != null) {
            LOGGER.debug("Attempting to cancel previous timeout task future for DtxBranch {}", (Object)this._xid);
            boolean succeeded = this._timeoutFuture.cancel(false);
            LOGGER.debug("Cancelling previous timeout task {} for DtxBranch {}", (Object)(succeeded ? "succeeded" : "failed"), (Object)this._xid);
        }
        this._timeout = timeout;
        long l = this._expiration = timeout == 0L ? 0L : System.currentTimeMillis() + 1000L * timeout;
        if (this._timeout == 0L) {
            this._timeoutFuture = null;
        } else {
            long delay = 1000L * this._timeout;
            LOGGER.debug("Scheduling timeout and rollback after {}s for DtxBranch {}", (Object)(delay / 1000L), (Object)this._xid);
            this._timeoutFuture = this._dtxRegistry.scheduleTask(delay, new Runnable(){

                @Override
                public void run() {
                    LOGGER.debug("Timing out DtxBranch {}", (Object)DtxBranch.this._xid);
                    DtxBranch.this.setState(State.TIMEDOUT);
                    DtxBranch.this.rollback();
                }
            });
        }
    }

    public boolean expired() {
        return this._timeout != 0L && this._expiration < System.currentTimeMillis();
    }

    public synchronized boolean isAssociated(AMQPSession<?, ?> session) {
        return this._associatedSessions.containsKey(session);
    }

    public synchronized boolean hasAssociatedSessions() {
        return !this._associatedSessions.isEmpty();
    }

    public synchronized boolean hasAssociatedActiveSessions() {
        if (this.hasAssociatedSessions()) {
            for (State state : this._associatedSessions.values()) {
                if (state == State.SUSPENDED) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void clearAssociations() {
        this._associatedSessions.clear();
    }

    synchronized boolean associateSession(AMQPSession<?, ?> associatedSession) {
        return this._associatedSessions.put(associatedSession, State.ACTIVE) != null;
    }

    synchronized boolean disassociateSession(AMQPSession<?, ?> associatedSession) {
        return this._associatedSessions.remove(associatedSession) != null;
    }

    public synchronized boolean resumeSession(AMQPSession<?, ?> session) {
        if (this._associatedSessions.containsKey(session) && this._associatedSessions.get(session) == State.SUSPENDED) {
            this._associatedSessions.put(session, State.ACTIVE);
            return true;
        }
        return false;
    }

    public synchronized boolean suspendSession(AMQPSession<?, ?> session) {
        if (this._associatedSessions.containsKey(session) && this._associatedSessions.get(session) == State.ACTIVE) {
            this._associatedSessions.put(session, State.SUSPENDED);
            return true;
        }
        return false;
    }

    public void prepare() throws StoreException {
        LOGGER.debug("Performing prepare for DtxBranch {}", (Object)this._xid);
        Transaction txn = this._dtxRegistry.getMessageStore().newTransaction();
        this._storedXidRecord = txn.recordXid(this._xid.getFormat(), this._xid.getGlobalId(), this._xid.getBranchId(), this._enqueueRecords.toArray(new EnqueueRecord[this._enqueueRecords.size()]), this._dequeueRecords.toArray(new DequeueRecord[this._dequeueRecords.size()]));
        txn.commitTran();
        this.prePrepareTransaction();
    }

    public synchronized void rollback() throws StoreException {
        LOGGER.debug("Performing rollback for DtxBranch {}", (Object)this._xid);
        if (this._timeoutFuture != null) {
            LOGGER.debug("Attempting to cancel previous timeout task future for DtxBranch {}", (Object)this._xid);
            boolean succeeded = this._timeoutFuture.cancel(false);
            this._timeoutFuture = null;
            LOGGER.debug("Cancelling previous timeout task {} for DtxBranch {}", (Object)(succeeded ? "succeeded" : "failed"), (Object)this._xid);
        }
        if (this._transaction != null) {
            Transaction txn = this._dtxRegistry.getMessageStore().newTransaction();
            txn.removeXid(this._storedXidRecord);
            txn.commitTran();
            this._transaction.abortTran();
        }
        for (ServerTransaction.Action action : this._postTransactionActions) {
            action.onRollback();
        }
        this._postTransactionActions.clear();
    }

    public void commit() throws StoreException {
        LOGGER.debug("Performing commit for DtxBranch {}", (Object)this._xid);
        if (this._timeoutFuture != null) {
            LOGGER.debug("Attempting to cancel previous timeout task future for DtxBranch {}", (Object)this._xid);
            boolean succeeded = this._timeoutFuture.cancel(false);
            this._timeoutFuture = null;
            LOGGER.debug("Cancelling previous timeout task {} for DtxBranch {}", (Object)(succeeded ? "succeeded" : "failed"), (Object)this._xid);
        }
        if (this._transaction == null) {
            this.prePrepareTransaction();
        } else {
            this._transaction.removeXid(this._storedXidRecord);
        }
        this._transaction.commitTran();
        for (ServerTransaction.Action action : this._postTransactionActions) {
            action.postCommit();
        }
        this._postTransactionActions.clear();
    }

    public void prePrepareTransaction() throws StoreException {
        this._transaction = this._dtxRegistry.getMessageStore().newTransaction();
        for (EnqueueRecord enqueue : this._enqueueRecords) {
            MessageEnqueueRecord record = enqueue.isDurable() ? this._transaction.enqueueMessage(enqueue.getResource(), enqueue.getMessage()) : null;
            enqueue.getEnqueueAction().performAction(record);
        }
        for (DequeueRecord dequeue : this._dequeueRecords) {
            this._transaction.dequeueMessage(dequeue.getEnqueueRecord());
        }
    }

    public void addPostTransactionAction(ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
    }

    public void dequeue(MessageEnqueueRecord record) {
        if (record != null) {
            this._dequeueRecords.add(new DequeueRecord(record));
        }
    }

    public void enqueue(TransactionLogResource queue, EnqueueableMessage message, Action<MessageEnqueueRecord> enqueueAction) {
        this._enqueueRecords.add(new EnqueueRecord(queue, message, enqueueAction));
    }

    public void close() {
        if (this._transaction != null) {
            this._state = null;
            this._transaction.abortTran();
        }
    }

    private static class EnqueueRecord
    implements Transaction.EnqueueRecord {
        private final TransactionLogResource _resource;
        private final EnqueueableMessage _message;
        private final Action<MessageEnqueueRecord> _enqueueAction;

        public EnqueueRecord(TransactionLogResource resource, EnqueueableMessage message, Action<MessageEnqueueRecord> enqueueAction) {
            this._resource = resource;
            this._message = message;
            this._enqueueAction = enqueueAction;
        }

        public Action<MessageEnqueueRecord> getEnqueueAction() {
            return this._enqueueAction;
        }

        @Override
        public TransactionLogResource getResource() {
            return this._resource;
        }

        @Override
        public EnqueueableMessage getMessage() {
            return this._message;
        }

        public boolean isDurable() {
            return this._resource.getMessageDurability().persist(this._message.isPersistent());
        }
    }

    private static class DequeueRecord
    implements Transaction.DequeueRecord {
        private final MessageEnqueueRecord _enqueueRecord;

        public DequeueRecord(MessageEnqueueRecord enqueueRecord) {
            this._enqueueRecord = enqueueRecord;
        }

        @Override
        public MessageEnqueueRecord getEnqueueRecord() {
            return this._enqueueRecord;
        }
    }

    public static enum State {
        ACTIVE,
        PREPARED,
        TIMEDOUT,
        SUSPENDED,
        FORGOTTEN,
        HEUR_COM,
        HEUR_RB,
        ROLLBACK_ONLY;

    }
}

