/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.test.mqtt.hivemq;

import com.hivemq.embedded.EmbeddedHiveMQ;
import com.hivemq.embedded.EmbeddedHiveMQBuilder;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import java.io.File;
import test.de.iip_ecosphere.platform.transport.AbstractTestServer;

public class TestHiveMqServer
extends AbstractTestServer {
    public static final String KEYSTORE_PASSWORD = "a1234567";
    public static final String TRUSTSTORE_PASSWORD = "a1234567";
    public static final String KEY_ALIAS = "qpid";
    private EmbeddedHiveMQ hiveMQ;
    private ServerAddress addr;
    private File hiveTmp;

    public TestHiveMqServer(ServerAddress addr) {
        this.addr = addr;
    }

    public Server start() {
        if (null == this.hiveMQ) {
            FileUtils.listFiles((File)FileUtils.getTempDirectory(), f -> f.getName().startsWith("hivemq_v5"), f -> FileUtils.deleteQuietly((File)f));
            this.hiveTmp = FileUtils.createTmpFolder((String)"hivemq_v5", (boolean)true);
            System.setProperty("HIVEMQ_PORT", Integer.toString(this.addr.getPort()));
            System.setProperty("HIVEMQ_ADDRESS", this.addr.getHost());
            System.setProperty("hivemq.log.folder", this.hiveTmp.getAbsolutePath());
            System.setProperty("hivemq.data.folder", this.hiveTmp.getAbsolutePath());
            File cfg = TestHiveMqServer.getConfigDir((String)"./src/test");
            System.setProperty("HIVEMQ_CFG", cfg.getAbsolutePath());
            EmbeddedHiveMQBuilder embeddedHiveMQBuilder = EmbeddedHiveMQBuilder.builder().withConfigurationFolder(cfg.toPath()).withDataFolder(this.hiveTmp.toPath()).withExtensionsFolder(new File(cfg, "extensions").toPath());
            this.hiveMQ = embeddedHiveMQBuilder.build();
            this.hiveMQ.start().join();
        }
        return this;
    }

    public void stop(boolean dispose) {
        if (null != this.hiveMQ) {
            this.hiveMQ.stop().join();
            this.hiveMQ = null;
            if (dispose && this.hiveTmp != null) {
                FileUtils.deleteQuietly((File)this.hiveTmp);
            }
        }
    }

    protected static ServerAddress getServerAddress(String[] args) {
        return new ServerAddress(Schema.IGNORE, CmdLine.getArg((String[])args, (String)"host", (String)"localhost"), TestHiveMqServer.getInteger((String[])args, (int)8883));
    }

    public static void main(String[] args) {
        TestHiveMqServer server = new TestHiveMqServer(TestHiveMqServer.getServerAddress(args));
        server.scheduleShutdownHook(true);
        server.start();
    }
}

