/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.CachingStrategy;
import de.iip_ecosphere.platform.connectors.ConnectorField;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.DefaultCachingStrategy;
import de.iip_ecosphere.platform.connectors.events.DataTimeDifferenceProvider;
import de.iip_ecosphere.platform.connectors.events.EventHandlingConnector;
import de.iip_ecosphere.platform.connectors.model.SharedSpace;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public interface Connector<O, I, CO, CI>
extends EventHandlingConnector {
    public void connect(ConnectorParameter var1) throws IOException;

    public CO request(boolean var1) throws IOException;

    public void write(CI var1) throws IOException;

    public void setReceptionCallback(ReceptionCallback<CO> var1) throws IOException;

    default public void setReceptionCallbackSafe(ReceptionCallback<CO> callback) {
        try {
            this.setReceptionCallback(callback);
        }
        catch (IOException e) {
            LoggerFactory.getLogger((Object)this).error("While setting reception callback: {}", (Object)e.getMessage());
        }
    }

    public void disconnect() throws IOException;

    default public void disconnectSafe() {
        try {
            this.disconnect();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).warn("While disconnecting: {}", (Object)e.getMessage());
        }
    }

    public void dispose();

    public Class<? extends I> getProtocolInputType();

    public Class<? extends CI> getConnectorInputType();

    public Class<? extends O> getProtocolOutputType();

    public Class<? extends CO> getConnectorOutputType();

    public String supportedEncryption();

    public String enabledEncryption();

    public void enableNotifications(boolean var1);

    default public Class<? extends CachingStrategy> getCachingStrategyCls() {
        return DefaultCachingStrategy.class;
    }

    default public void notifyReconfigured(String parameterName, String value) {
    }

    default public void setDataTimeDifferenceProvider(DataTimeDifferenceProvider<CO> provider) {
    }

    public void setInstanceIdentification(String var1);

    public String getInstanceIdentification();

    default public SharedSpace createSharedSpace() {
        return null;
    }

    default public boolean enableSharedSpace(SharedSpace space) {
        return false;
    }

    default public void notificationsChanged(boolean useNotifications) {
    }

    default public List<ConnectorField> enumerateFields() {
        return this.enumerateFields("");
    }

    default public List<ConnectorField> enumerateFields(String path) {
        return new ArrayList<ConnectorField>();
    }
}

