/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorRegistry;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.ClassUtility;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.Iterator;

public class ConnectorsAas
implements AasContributor {
    public static final String NAME_DESCRIPTORS_SUBMODEL = "installedConnectors";
    public static final String NAME_DESC_VAR_NAME = "name";
    public static final String NAME_DESC_VAR_SUPPORTS_EVENTS = "supportsEvents";
    public static final String NAME_DESC_VAR_HAS_MODEL = "hasModel";
    public static final String NAME_DESC_VAR_SUPPORTS_QNAMES = "supportsQualifiedNames";
    public static final String NAME_DESC_VAR_SUPPORTS_PROPERTIES = "supportsProperties";
    public static final String NAME_DESC_VAR_SUPPORTS_CALLS = "supportsCalls";
    public static final String NAME_DESC_VAR_SUPPORTS_STRUCTS = "supportsStructs";
    public static final String NAME_CONNECTORS_SUBMODEL = "activeConnectors";
    public static final String NAME_SMC_CONNECTOR_PREFIX = "connector_";
    public static final String NAME_SMC_VAR_CONNECTOR = "name";
    public static final String NAME_SMC_VAR_OUT = "outType";
    public static final String NAME_SMC_VAR_IN = "inType";
    public static final String NAME_SMC_VAR_DESCRIPTOR = "descriptor";
    public static final String NAME_SMC_VAR_SUPPORTED_ENC = "supportedEncryption";
    public static final String NAME_SMC_VAR_ENABLED_ENC = "enabledEncryption";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorsAas.class);

    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        Submodel.SubmodelBuilder tsmB = AasPartRegistry.createSubmodelBuilderRbac((Aas.AasBuilder)aasBuilder, (String)"types");
        if (tsmB.isNew()) {
            tsmB.build();
            Submodel.SubmodelBuilder ismB = AasPartRegistry.createSubmodelBuilderRbac((Aas.AasBuilder)aasBuilder, (String)NAME_DESCRIPTORS_SUBMODEL);
            Iterator<ConnectorDescriptor> iter = ConnectorRegistry.getRegisteredConnectorDescriptors();
            while (iter.hasNext()) {
                ConnectorDescriptor desc = iter.next();
                Class<?> cls = desc.getClass();
                SubmodelElementCollection.SubmodelElementCollectionBuilder secB = ismB.createSubmodelElementCollectionBuilder(ClassUtility.getName(desc.getConnectorType()));
                secB.createPropertyBuilder("name").setValue(Type.STRING, (Object)desc.getName()).build();
                ConnectorsAas.addAnnotationInformation(secB, cls);
                secB.build();
            }
            Submodel descriptors = (Submodel)ismB.build();
            Submodel.SubmodelBuilder csmB = AasPartRegistry.createSubmodelBuilderRbac((Aas.AasBuilder)aasBuilder, (String)NAME_CONNECTORS_SUBMODEL);
            Iterator<Connector<?, ?, ?, ?>> iterC = ConnectorRegistry.getRegisteredConnectorInstances();
            while (iterC.hasNext()) {
                Connector<?, ?, ?, ?> connector = iterC.next();
                String idShort = ClassUtility.getId((String)NAME_SMC_CONNECTOR_PREFIX, connector);
                SubmodelElementCollection.SubmodelElementCollectionBuilder smcb = csmB.createSubmodelElementCollectionBuilder(idShort);
                ConnectorsAas.addConnector(smcb, connector, descriptors);
                smcb.build();
            }
            csmB.build();
        }
        return null;
    }

    static void notifyRemoveConnector(Connector<?, ?, ?, ?> connector) {
        ActiveAasBase.processNotification((String)NAME_CONNECTORS_SUBMODEL, (submodel, aas) -> {
            String idShort = ClassUtility.getId((String)NAME_SMC_CONNECTOR_PREFIX, (Object)connector);
            SubmodelElementCollection coll = submodel.getSubmodelElementCollection(idShort);
            if (null != coll) {
                submodel.deleteElement((SubmodelElement)coll);
            } else {
                LOGGER.error("No element collection for connector: activeConnectors/" + idShort);
            }
        });
    }

    static void notifyAddConnector(Connector<?, ?, ?, ?> connector) {
        ActiveAasBase.processNotification((String)NAME_CONNECTORS_SUBMODEL, (submodel, aas) -> {
            Submodel descriptors = aas.getSubmodel(NAME_DESCRIPTORS_SUBMODEL);
            if (null != submodel && null != descriptors) {
                String idShort = ClassUtility.getId((String)NAME_SMC_CONNECTOR_PREFIX, (Object)connector);
                SubmodelElementCollection.SubmodelElementCollectionBuilder smcb = submodel.createSubmodelElementCollectionBuilder(idShort);
                ConnectorsAas.addConnector(smcb, connector, descriptors);
                smcb.build();
            } else {
                LOGGER.error("No submodel: activeConnectors");
            }
        });
    }

    private static void addConnector(SubmodelElementCollection.SubmodelElementCollectionBuilder smcb, Connector<?, ?, ?, ?> connector, Submodel descriptors) {
        smcb.createPropertyBuilder("name").setValue(Type.STRING, (Object)connector.getName()).build();
        ClassUtility.addTypeSubModelElement((SubmodelElementContainerBuilder)smcb, (String)NAME_SMC_VAR_OUT, connector.getConnectorOutputType());
        ClassUtility.addTypeSubModelElement((SubmodelElementContainerBuilder)smcb, (String)NAME_SMC_VAR_IN, connector.getConnectorInputType());
        smcb.createPropertyBuilder(NAME_SMC_VAR_SUPPORTED_ENC).setValue(Type.STRING, (Object)ConnectorsAas.toValidString(connector.supportedEncryption())).build();
        smcb.createPropertyBuilder(NAME_SMC_VAR_ENABLED_ENC).setType(Type.STRING).setValue(Type.STRING, (Object)ConnectorsAas.toValidString(connector.enabledEncryption())).build();
        String descName = ClassUtility.getName(connector.getClass());
        SubmodelElementCollection descC = descriptors.getSubmodelElementCollection(descName);
        if (null != descC) {
            smcb.createReferenceElementBuilder(NAME_SMC_VAR_DESCRIPTOR).setValue(descC.createReference()).build();
        } else {
            LOGGER.warn("Warning while adding connector instance: Descriptor for " + descName + " does not exist.");
        }
    }

    private static String toValidString(String string) {
        return null == string ? "" : string;
    }

    public static MachineConnector getMachineConnectorAnnotation(Class<?> cls) {
        MachineConnector conn = cls.getAnnotation(MachineConnector.class);
        if (null == conn) {
            conn = DefaultAnnotationProvider.class.getAnnotation(MachineConnector.class);
        }
        return conn;
    }

    private static void addAnnotationInformation(SubmodelElementCollection.SubmodelElementCollectionBuilder smcb, Class<?> cls) {
        MachineConnector conn = ConnectorsAas.getMachineConnectorAnnotation(cls);
        smcb.createPropertyBuilder(NAME_DESC_VAR_SUPPORTS_EVENTS).setValue(Type.BOOLEAN, (Object)conn.supportsEvents()).build();
        smcb.createPropertyBuilder(NAME_DESC_VAR_HAS_MODEL).setValue(Type.BOOLEAN, (Object)conn.hasModel()).build();
        smcb.createPropertyBuilder(NAME_DESC_VAR_SUPPORTS_QNAMES).setValue(Type.BOOLEAN, (Object)conn.supportsHierarchicalQNames()).build();
        smcb.createPropertyBuilder(NAME_DESC_VAR_SUPPORTS_PROPERTIES).setValue(Type.BOOLEAN, (Object)conn.supportsModelProperties()).build();
        smcb.createPropertyBuilder(NAME_DESC_VAR_SUPPORTS_CALLS).setValue(Type.BOOLEAN, (Object)conn.supportsModelCalls()).build();
        smcb.createPropertyBuilder(NAME_DESC_VAR_SUPPORTS_STRUCTS).setValue(Type.BOOLEAN, (Object)conn.supportsModelStructs()).build();
    }

    public void contributeTo(ProtocolServerBuilder sBuilder) {
    }

    public AasContributor.Kind getKind() {
        return AasContributor.Kind.DYNAMIC;
    }

    public boolean isValid() {
        return true;
    }

    @MachineConnector(specificSettings={})
    private static class DefaultAnnotationProvider {
        private DefaultAnnotationProvider() {
        }
    }
}

