/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.parser;

import de.iip_ecosphere.platform.connectors.parser.InputParser;
import de.iip_ecosphere.platform.support.ClassLoaderUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ParserUtils {
    public static InputParser<?> createInstance(ClassLoader loader, String className, String charset) {
        InputParser result = null;
        try {
            Class<?> parserClass = loader.loadClass(className);
            Object instance = null;
            try {
                Constructor<?> cons = parserClass.getConstructor(String.class);
                instance = cons.newInstance(charset);
            }
            catch (NoSuchMethodException cons) {
            }
            catch (InvocationTargetException e) {
                LoggerFactory.getLogger(ParserUtils.class).error("While instantiating " + className + ": " + e.getMessage() + ", falling back to default constructor");
            }
            if (null == instance) {
                instance = parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            result = instance;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String loaders = ClassLoaderUtils.hierarchyToString((ClassLoader)loader);
            LoggerFactory.getLogger(ParserUtils.class).error("Cannot instantiate parser of type '" + className + " via " + loaders + "': " + e.getClass().getSimpleName() + " " + e.getMessage() + ". No input parser will be used!");
        }
        return result;
    }
}

