/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.commons.Commons;
import java.io.File;

public class OsUtils {
    public static final String PROP_JAVA_HOME = "java.home";
    public static final String PROP_USER_HOME = "user.home";

    private OsUtils() {
    }

    public static final String getUserHome() {
        return Commons.getInstance().getUserHome();
    }

    public static final String getOsName() {
        return Commons.getInstance().getOsName();
    }

    public static File getJavaHome() {
        return Commons.getInstance().getJavaHome();
    }

    public static String getJavaSpecificationVersion() {
        return Commons.getInstance().getJavaSpecificationVersion();
    }

    public static final String getOsArch() {
        return Commons.getInstance().getOsArch();
    }

    public static final int getNumCpuCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static String getEnv(String key) {
        String result = System.getenv(key);
        if (null == result) {
            result = System.getenv(key.toUpperCase().replace('.', '_'));
        }
        return result;
    }

    public static String getPropertyOrEnv(String key, String dflt) {
        String result = System.getProperty(key);
        if (null == result) {
            result = OsUtils.getEnv(key);
        }
        return null == result ? dflt : result;
    }

    public static boolean getBooleanPropertyOrEnv(String key, boolean dflt) {
        return Boolean.valueOf(OsUtils.getPropertyOrEnv(key, String.valueOf(dflt)));
    }

    public static String getPropertyOrEnv(String key) {
        return OsUtils.getPropertyOrEnv(key, null);
    }

    public static boolean isWindows() {
        return Commons.getInstance().isWindows();
    }

    public static boolean isLinux() {
        return Commons.getInstance().isLinux();
    }

    public static boolean isUnix() {
        return Commons.getInstance().isUnix();
    }

    public static boolean isMac() {
        return Commons.getInstance().isMac();
    }

    public static boolean isJava1_8() {
        return Commons.getInstance().isJava1_8();
    }

    public static boolean isAtLeastJava9() {
        return Commons.getInstance().isAtLeastJava9();
    }
}

