/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.commons.Commons;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class TimeUtils {
    public static final String ISO8601_FORMAT = "ISO8601";
    private static final Map<String, SimpleDateFormat> DATE_FORMATTER = new HashMap<String, SimpleDateFormat>();
    private static final Map<Class<?>, DateConverter<?>> CONVERTERS = new HashMap();

    private TimeUtils() {
    }

    public static void registerConverter(DateConverter<?> converter) {
        if (null != converter) {
            CONVERTERS.put(converter.getDataType(), converter);
        }
    }

    public static void registerFormat(String name, String pattern) {
        if (null != name && null != pattern) {
            DATE_FORMATTER.put(name, new SimpleDateFormat(pattern));
        }
    }

    public static String format(Date data, String format) throws IOException {
        SimpleDateFormat sdf = TimeUtils.getDateFormatter(format);
        return sdf.format(data);
    }

    private static <T> Date convertToDate(Class<T> cls, Object data) {
        Date result = null;
        DateConverter<?> conv = CONVERTERS.get(cls);
        if (null != conv) {
            result = conv.toDate(data);
        }
        return result;
    }

    public static Date parse(Object data, String format) throws IOException {
        Date result = null;
        if (null != data && null == (result = TimeUtils.convertToDate(data.getClass(), data))) {
            String tmp = null == data ? "" : data.toString();
            SimpleDateFormat f = TimeUtils.getDateFormatter(format);
            try {
                return f.parse(tmp);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    public static SimpleDateFormat getDateFormatter(String format) throws IOException {
        SimpleDateFormat result = DATE_FORMATTER.get(format);
        if (null == result) {
            try {
                result = new SimpleDateFormat(format);
                DATE_FORMATTER.put(format, result);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        LocalDateTime result = null == date ? null : date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return result;
    }

    public static Date toDate(LocalDateTime date) {
        Date result = null == date ? null : Date.from(date.atZone(ZoneId.systemDefault()).toInstant());
        return result;
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean waitFor(Supplier<Boolean> continueCondition, int timeoutMs, int sleepMs) {
        boolean endConditionMet = false;
        long start = System.currentTimeMillis();
        while (timeoutMs < 0 || System.currentTimeMillis() - start < (long)timeoutMs) {
            boolean bl = endConditionMet = continueCondition.get() == false;
            if (endConditionMet) break;
            TimeUtils.sleep(sleepMs);
        }
        return endConditionMet;
    }

    static {
        TimeUtils.registerConverter(new AbstractDateConverter<Date>(Date.class){

            @Override
            public Date toDate(Date data) {
                return data;
            }
        });
        Commons.getInstance().registerDateConverters();
        TimeUtils.registerConverter(new AbstractDateConverter<LocalDateTime>(LocalDateTime.class){

            @Override
            public Date toDate(LocalDateTime data) {
                return TimeUtils.toDate(data);
            }
        });
        TimeUtils.registerFormat(ISO8601_FORMAT, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static interface DateConverter<T> {
        public Date toDate(T var1);

        public Class<T> getDataType();
    }

    public static abstract class AbstractDateConverter<T>
    implements DateConverter<T> {
        private Class<T> cls;

        protected AbstractDateConverter(Class<T> cls) {
            this.cls = cls;
        }

        @Override
        public Class<T> getDataType() {
            return this.cls;
        }
    }
}

