/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.json;

import de.iip_ecosphere.platform.support.Include;
import de.iip_ecosphere.platform.support.TaskRegistry;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class JsonResultWrapper
implements Function<Object[], Object>,
Serializable {
    private static final long serialVersionUID = 6531890963314078947L;
    private static final Json MAPPER = Json.createInstance4All();
    private ExceptionFunction func;
    private OperationCompletedListener listener;
    private Function<Object[], String> taskIdSupplier;

    public JsonResultWrapper(ExceptionFunction func) {
        this(func, null, null);
    }

    public JsonResultWrapper(ExceptionFunction func, OperationCompletedListener listener) {
        this(func, listener, null);
    }

    public JsonResultWrapper(ExceptionFunction func, Function<Object[], String> taskIdSupplier) {
        this(func, null, taskIdSupplier);
    }

    public JsonResultWrapper(ExceptionFunction func, OperationCompletedListener listener, Function<Object[], String> taskIdSupplier) {
        this.func = func;
        this.listener = listener;
        this.taskIdSupplier = taskIdSupplier;
    }

    @Override
    public Object apply(Object[] param) {
        Result result;
        block7: {
            String taskId = null;
            if (null != this.taskIdSupplier) {
                taskId = this.taskIdSupplier.apply(param);
            }
            try {
                Object funcRes;
                if (null != taskId) {
                    TaskRegistry.registerTask(taskId);
                }
                result = new Result(null == (funcRes = this.func.apply(param)) ? null : funcRes.toString());
                if (null != this.listener) {
                    this.listener.operationCompleted();
                }
                if (null != taskId) {
                    TaskRegistry.stopTask(taskId);
                }
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(this.getClass()).error("Operation execution failed: {}", (Object)e.getMessage());
                LoggerFactory.getLogger(this.getClass()).trace("Oktoflow debug catch: ", e);
                result = new Result(e);
                if (null != this.listener) {
                    this.listener.operationFailed();
                }
                if (null == taskId) break block7;
                TaskRegistry.stopTask(taskId);
            }
        }
        return JsonResultWrapper.toJson(result);
    }

    public static String toJson(Result res) {
        String result = "";
        if (null != res) {
            try {
                result = MAPPER.writeValueAsString(res);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Result resultFromJson(Object json) {
        Result result = null;
        if (null != json) {
            try {
                result = MAPPER.readValue(json.toString(), Result.class);
            }
            catch (IOException e) {
                result = new Result(e);
            }
        }
        return result;
    }

    public static String fromJson(Object json) throws ExecutionException {
        String result;
        Result res = JsonResultWrapper.resultFromJson(json);
        if (null != res) {
            if (res.isException()) {
                throw new ExecutionException(res.getException(), null);
            }
            result = res.getResult();
        } else {
            result = null;
        }
        return result;
    }

    public static String fromJson(Function<Object[], Object> function, Object ... params) throws ExecutionException {
        try {
            return JsonResultWrapper.fromJson(function.apply(params));
        }
        catch (Throwable t) {
            throw new ExecutionException(t.getMessage(), t);
        }
    }

    public static interface ExceptionFunction
    extends Serializable {
        public Object apply(Object[] var1) throws Exception;
    }

    public static interface OperationCompletedListener {
        public void operationCompleted();

        public void operationFailed();
    }

    public static class Result
    implements Serializable {
        private static final long serialVersionUID = -4586150559933545643L;
        @Include(value=Include.Type.NON_NULL)
        private String result;
        @Include(value=Include.Type.NON_NULL)
        private String exception;

        private Result() {
        }

        private Result(String result) {
            this.result = result;
        }

        private Result(Throwable ex) {
            this.exception = ex.getMessage();
        }

        public String getResult() {
            return this.result;
        }

        public String getException() {
            return this.exception;
        }

        public boolean isException() {
            return null != this.exception;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public void setException(String exception) {
            this.exception = exception;
        }
    }
}

