/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ChildFirstIndexedClassloader
extends ClassLoader {
    private final Map<String, String> locationIndex;
    private final Map<String, String> classIndex;
    private final Map<String, String> resourceIndex;
    private final Map<Path, JarFile> jarCache = new ConcurrentHashMap<Path, JarFile>();

    public ChildFirstIndexedClassloader(Map<String, String> locationIndex, Map<String, String> classIndex, Map<String, String> resourceIndex, ClassLoader parent) {
        super(parent);
        this.locationIndex = locationIndex;
        this.classIndex = classIndex;
        this.resourceIndex = resourceIndex;
    }

    public ChildFirstIndexedClassloader(LoaderIndex index, ClassLoader parent) {
        this(index.locationIndex, index.classIndex, index.resourceIndex, parent);
    }

    public ChildFirstIndexedClassloader(File index, ClassLoader parent) throws IOException {
        this(LoaderIndex.fromFile(index), parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        block10: {
            String locStr = this.classIndex.get(name);
            if (null == locStr) {
                throw new ClassNotFoundException(name);
            }
            String jarPathStr = this.locationIndex.get(locStr);
            Path jarPath = Paths.get(jarPathStr, new String[0]);
            JarFile jar = this.jarCache.computeIfAbsent(jarPath, this::openJar);
            String entryName = name.replace('.', '/') + ".class";
            JarEntry entry = jar.getJarEntry(entryName);
            if (null == entry) {
                throw new ClassNotFoundException(name);
            }
            InputStream in = jar.getInputStream(entry);
            try {
                byte[] bytes = ChildFirstIndexedClassloader.readAllBytes(in);
                clazz = this.defineClass(name, bytes, 0, bytes.length);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalArgumentException e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
            in.close();
        }
        return clazz;
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = in.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    @Override
    public URL findResource(String name) {
        String locStr = this.resourceIndex.get(name);
        if (null == locStr) {
            return null;
        }
        String jarPathStr = this.locationIndex.get(locStr);
        Path jarPath = Paths.get(jarPathStr, new String[0]);
        try {
            JarFile jar = this.jarCache.computeIfAbsent(jarPath, this::openJar);
            JarEntry entry = jar.getJarEntry(name);
            if (null == entry) {
                return null;
            }
            return new URL("jar:file:" + jarPath.toAbsolutePath() + "!/" + name);
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.findResource(name);
        if (null == url) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    private JarFile openJar(Path path) throws IllegalArgumentException {
        try {
            return new JarFile(path.toFile(), false);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to open jar: " + path, e);
        }
    }

    public void close() throws IOException {
        for (JarFile jar : this.jarCache.values()) {
            jar.close();
        }
        this.jarCache.clear();
    }

    static {
        ChildFirstIndexedClassloader.registerAsParallelCapable();
    }

    public static class LoaderIndex
    implements Serializable {
        private static final long serialVersionUID = -3350988607004003802L;
        private Map<String, String> locationIndex = new HashMap<String, String>();
        private Map<String, String> classIndex = new HashMap<String, String>();
        private Map<String, String> resourceIndex = new HashMap<String, String>();

        public static LoaderIndex fromFile(File indexFile) throws IOException {
            LoaderIndex loaderIndex;
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(indexFile)));
            try {
                loaderIndex = (LoaderIndex)ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            ois.close();
            return loaderIndex;
        }

        public static void toFile(LoaderIndex index, File file) throws IOException {
            try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                oos.writeObject(index);
            }
        }

        public static void addToIndex(LoaderIndex index, boolean isClass, String name, String location) {
            String loc = index.locationIndex.get(location);
            if (null == loc) {
                loc = String.valueOf(index.locationIndex.size());
                index.locationIndex.put(loc, location);
            }
            Map<String, String> map = isClass ? index.classIndex : index.resourceIndex;
            map.put(name, loc);
        }
    }
}

