/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.plugins;

import de.iip_ecosphere.platform.support.plugins.ChildClassLoader;
import de.iip_ecosphere.platform.support.plugins.FindClassClassLoader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

class ChildURLClassLoader
extends URLClassLoader
implements ChildClassLoader {
    private FindClassClassLoader realParent;

    public ChildURLClassLoader(URL[] urls, FindClassClassLoader realParent) {
        super(urls, (ClassLoader)null);
        this.realParent = realParent;
    }

    @Override
    public URL getResource(String name) {
        URL result = this.findResource(name);
        if (null == result) {
            result = this.realParent.getResource(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> result = this.findResources(name);
        if (null == result) {
            result = this.realParent.getResources(name);
        }
        return result;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (null == result) {
            result = this.findClassIntern(name);
        }
        return result;
    }

    public Class<?> findClassIntern(String name) throws ClassNotFoundException {
        boolean isJava = name.startsWith("java.") || name.startsWith("javax.");
        try {
            if (isJava) {
                return this.realParent.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.realParent.loadClass(name);
        }
    }

    static {
        ChildURLClassLoader.registerAsParallelCapable();
    }
}

