/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.plugins;

import de.iip_ecosphere.platform.support.IOUtils;
import de.iip_ecosphere.platform.support.ZipUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.PluginDescriptor;
import de.iip_ecosphere.platform.support.plugins.URLPluginSetupDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Stream;

public class FolderClasspathPluginSetupDescriptor
extends URLPluginSetupDescriptor {
    public static final String KEY_SETUP_DESCRIPTOR = "# setupDescriptor: ";
    public static final String KEY_PLUGIN_IDS = "# pluginIds: ";
    private File installDir;
    private boolean descriptorOnly;
    private File indexFile;

    public FolderClasspathPluginSetupDescriptor(File folder) {
        this(folder, false, new File[0]);
    }

    public FolderClasspathPluginSetupDescriptor(File folder, boolean descriptorOnly, File ... appends) {
        super(FolderClasspathPluginSetupDescriptor.loadClasspathSafe(folder, descriptorOnly, appends));
        File idxFile;
        this.installDir = folder;
        this.descriptorOnly = descriptorOnly;
        File cpFile = FolderClasspathPluginSetupDescriptor.findClasspathFile(folder, "");
        if (cpFile.isFile() && (idxFile = new File(cpFile.toString() + ".idx")).exists()) {
            this.indexFile = idxFile;
        }
    }

    @Override
    public File getInstallDir() {
        return this.installDir;
    }

    public static File findClasspathFile(File folder, String suffix) {
        File result;
        String string = suffix = suffix == null ? "" : suffix;
        if (folder.isFile()) {
            result = new File(folder + suffix);
        } else {
            result = new File(folder, "classpath" + suffix);
            if (!result.exists()) {
                result = new File(folder, "target/jars/classpath" + suffix);
            }
            if (!result.exists()) {
                result = new File(folder, "target/classes/classpath" + suffix);
            }
        }
        return result;
    }

    public static File adjustBase(File folder) {
        File result = folder;
        if (result.isFile() && "plugins".equals((result = result.getParentFile()).getName())) {
            result = result.getParentFile();
        }
        return result;
    }

    public static URL[] loadClasspathSafe(File folder, boolean descriptorOnly, File ... appends) {
        return FolderClasspathPluginSetupDescriptor.loadClasspathFileSafe(FolderClasspathPluginSetupDescriptor.findClasspathFile(folder, ""), FolderClasspathPluginSetupDescriptor.adjustBase(folder), descriptorOnly, appends);
    }

    public static URL[] loadClasspathFileSafe(File cpFile, boolean descriptorOnly) {
        return FolderClasspathPluginSetupDescriptor.loadClasspathFileSafe(cpFile, cpFile.getParentFile(), descriptorOnly, new File[0]);
    }

    private static URL[] loadClasspathFileSafe(File cpFile, File base, boolean descriptorOnly, File ... appends) {
        URL[] result = null;
        try (FileInputStream in = new FileInputStream(cpFile);){
            FolderClasspathPluginSetupDescriptor.getLogger().info("Loading classpath from '{}' (descriptorOnly: {})", (Object)cpFile, (Object)descriptorOnly);
            ClasspathFile cpf = FolderClasspathPluginSetupDescriptor.readClasspathFile(in, base);
            if (null != appends) {
                for (File a : appends) {
                    if (!a.isFile()) {
                        a = new File(a, "target/jars/classpath");
                    }
                    try (FileInputStream aIn = new FileInputStream(a);){
                        FolderClasspathPluginSetupDescriptor.getLogger().info("Appending classpath from '{}'", (Object)a);
                        ClasspathFile aCpf = FolderClasspathPluginSetupDescriptor.readClasspathFile(aIn, base);
                        cpf.entries.addAll(aCpf.entries);
                    }
                    catch (IOException e) {
                        FolderClasspathPluginSetupDescriptor.getLogger().warn("While reading append classpath from '{}': {} Ignoring.", (Object)a, (Object)e.getMessage());
                    }
                }
            }
            ArrayList entries = new ArrayList(cpf.entries);
            if (descriptorOnly && entries.size() > 1) {
                ArrayList<File> tmp = new ArrayList<File>();
                tmp.add((File)entries.get(0));
                String first = FolderClasspathPluginSetupDescriptor.stripExtension(((File)entries.get(0)).getName());
                String second = FolderClasspathPluginSetupDescriptor.stripExtension(((File)entries.get(1)).getName());
                if (second.startsWith(first)) {
                    tmp.add((File)entries.get(1));
                }
                entries = tmp;
            }
            result = FolderClasspathPluginSetupDescriptor.toURLSafe(entries.toArray(new File[entries.size()]));
        }
        catch (IOException e) {
            FolderClasspathPluginSetupDescriptor.getLogger().error("While reading classpath from '{}': {} Ignoring.", (Object)cpFile, (Object)e.getMessage());
        }
        if (null == result) {
            result = new URL[]{};
        }
        return result;
    }

    public static ClasspathFile readClasspathFile(InputStream in, File base) throws IOException {
        ClasspathFile result = new ClasspathFile();
        List<String> contents = IOUtils.readLines(in);
        for (String line : contents) {
            if (line.startsWith("#")) {
                if (line.startsWith(KEY_SETUP_DESCRIPTOR)) {
                    result.setupDescriptor = line.substring(KEY_SETUP_DESCRIPTOR.length()).trim();
                }
                if (!line.startsWith(KEY_PLUGIN_IDS)) continue;
                result.pluginIds = new ArrayList();
                String tmp = line.substring(KEY_SETUP_DESCRIPTOR.length()).trim();
                StringTokenizer t = new StringTokenizer(tmp, ",");
                while (t.hasMoreTokens()) {
                    result.pluginIds.add(t.nextToken().trim());
                }
                continue;
            }
            StringTokenizer tokenizer = new StringTokenizer(line, ":;");
            while (tokenizer.hasMoreTokens()) {
                result.entries.add(new File(base, tokenizer.nextToken()));
            }
        }
        return result;
    }

    private static final String stripExtension(String name) {
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    @Override
    protected File getIndexFile() {
        return this.indexFile;
    }

    @Override
    protected ClassLoader createClassLoader(URL[] urls, ClassLoader parent) {
        return this.descriptorOnly ? new URLClassLoader(urls, parent) : super.createClassLoader(urls, parent);
    }

    @Override
    public Stream<PluginDescriptor> getPluginDescriptors(ClassLoader loader) {
        return FolderClasspathPluginSetupDescriptor.getPluginDescriptors(this.getURLs(), loader);
    }

    public static Stream<PluginDescriptor> getPluginDescriptors(URL[] urls, ClassLoader loader) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        String first = null;
        for (URL u : urls) {
            String name = FolderClasspathPluginSetupDescriptor.stripExtension(u.getFile());
            if (first != null) {
                if (!name.startsWith(first)) break;
                FolderClasspathPluginSetupDescriptor.loadDescriptors(u, loader, result);
                break;
            }
            first = name;
            FolderClasspathPluginSetupDescriptor.loadDescriptors(u, loader, result);
        }
        return result.stream();
    }

    private static void loadDescriptors(URL url, ClassLoader loader, List<PluginDescriptor> result) {
        try {
            InputStream in = ZipUtils.findFile(url.openStream(), "META-INF/services/" + PluginDescriptor.class.getName());
            if (in != null) {
                List<String> lines = IOUtils.readLines(in);
                for (String l : lines) {
                    try {
                        Class<?> cls = loader.loadClass(l);
                        if (PluginDescriptor.class.isAssignableFrom(cls)) {
                            result.add((PluginDescriptor)PluginDescriptor.class.cast(cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
                            continue;
                        }
                        FolderClasspathPluginSetupDescriptor.getLogger().warn("Loading plugin descriptor for {}: {} not of type PluginDescriptor. Ignoring", (Object)url, (Object)l);
                    }
                    catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        FolderClasspathPluginSetupDescriptor.getLogger().warn("Loading plugin descriptor for {}: {} {}. Ignoring", url, e.getClass().getSimpleName(), e.getMessage());
                    }
                }
                in.close();
            }
        }
        catch (IOException e) {
            FolderClasspathPluginSetupDescriptor.getLogger().warn("Loading plugin descriptor for {}: {}. Ignoring", (Object)url, (Object)e.getMessage());
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FolderClasspathPluginSetupDescriptor.class);
    }

    public static class ClasspathFile {
        private List<File> entries = new ArrayList<File>();
        private String setupDescriptor;
        private List<String> pluginIds;

        public List<File> getEntries() {
            return this.entries;
        }

        public String getSetupDescriptor() {
            return this.setupDescriptor;
        }

        public List<String> pluginIds() {
            return this.pluginIds;
        }
    }
}

