/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.python;

import de.iip_ecosphere.platform.tools.maven.python.PythonCompileMojo;
import de.iip_ecosphere.platform.tools.maven.python.PythonUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;

@Mojo(name="exec-python")
public class PythonExecMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="python-exec.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="python-exec.skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="python.binary", required=false, defaultValue="")
    private String python;
    @Parameter(property="python.pythonpath", required=false, defaultValue="")
    private String pythonPath;
    @Parameter(property="python-exec.file", required=true)
    private String pythonFile;
    @Parameter(property="python-exec.directory", required=false, defaultValue="src/test/python/")
    private String directory;
    @Parameter(property="python-exec.args", required=false, defaultValue="")
    private List<String> args;
    @Parameter(property="python-exec.pythonArgs", required=false, defaultValue="")
    private List<String> pythonArgs;
    @Parameter(required=false)
    private FileSet fileset;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            File win;
            File baseDir = this.project.getBasedir();
            String pythonExecutable = PythonUtils.getPythonExecutable(this.python).toString();
            this.getLog().info((CharSequence)("Using Python: " + pythonExecutable));
            String output = "";
            String[] envp = this.composeEnvironment();
            this.getLog().info((CharSequence)("Executing Python: " + this.pythonFile));
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(pythonExecutable.toString());
            if (null != this.pythonArgs) {
                cmd.addAll(this.pythonArgs);
            }
            cmd.add(this.pythonFile);
            if (null != this.args) {
                cmd.addAll(this.args);
            }
            if ((output = output + this.runPython(cmd.toArray(new String[cmd.size()]), new File(baseDir, this.directory).getAbsolutePath(), envp)).length() > 0) {
                this.getLog().info((CharSequence)output);
            }
            if ((win = new File("src/test/python/%SystemDrive%")).exists() && win.isDirectory()) {
                FileUtils.deleteQuietly((File)win);
            }
            if (output.contains("Traceback")) {
                throw new MojoExecutionException(output, null);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping Python execution");
        }
    }

    private String[] composeEnvironment() {
        CharSequence[] envp = null;
        ArrayList<String> tmp = new ArrayList<String>();
        if (null != this.pythonPath && this.pythonPath.length() > 0) {
            tmp.add("PYTHONPATH=" + this.pythonPath);
        }
        tmp.add("PRJ_HOME=" + new File("").getAbsolutePath());
        envp = tmp.toArray(new String[tmp.size()]);
        this.getLog().info((CharSequence)("Using " + String.join((CharSequence)", ", envp)));
        return envp;
    }

    private String runPython(String[] cmd, String workingDirectory, String[] envp) {
        String output = "";
        try {
            Process process = Runtime.getRuntime().exec(cmd, envp, new File(workingDirectory));
            output = PythonCompileMojo.readProcessOutput(process.getInputStream());
            output = output + PythonCompileMojo.readProcessOutput(process.getErrorStream());
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return output;
    }
}

