/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ListenerStartupInformation;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupListenerVerifier {
    private static final Logger log = LoggerFactory.getLogger(StartupListenerVerifier.class);
    private final List<ListenerStartupInformation> startupInformation;

    public StartupListenerVerifier(@NotNull List<ListenerStartupInformation> startupInformation) {
        Preconditions.checkNotNull(startupInformation);
        this.startupInformation = startupInformation;
    }

    public void verifyAndPrint() throws UnrecoverableException {
        if (this.startupInformation.isEmpty()) {
            log.error("No listener was configured. In order to operate properly, HiveMQ needs at least one listener. Shutting down HiveMQ");
            throw new UnrecoverableException(false);
        }
        int successfullyStarted = 0;
        for (ListenerStartupInformation startupInfo : this.startupInformation) {
            if (startupInfo.isSuccessful()) {
                log.info(this.getSuccessfulStartedString(startupInfo));
                ++successfullyStarted;
                continue;
            }
            log.error(this.getNotSuccessfulStartedString(startupInfo));
            if (!startupInfo.getException().isPresent()) continue;
            log.debug("Original Exception:", startupInfo.getException().get());
        }
        if (successfullyStarted < 1) {
            log.error("Could not bind any listener. Stopping HiveMQ.");
            throw new UnrecoverableException(false);
        }
    }

    @NotNull
    private String getSuccessfulStartedString(@NotNull ListenerStartupInformation startupInfo) {
        Listener listener = startupInfo.getListener();
        return String.format("Started %s on address %s and on port %s.", listener.readableName(), listener.getBindAddress(), listener.getPort());
    }

    @NotNull
    private String getNotSuccessfulStartedString(@NotNull ListenerStartupInformation startupInfo) {
        Listener listener = startupInfo.getListener();
        return String.format("Could not start %s on port %s and address %s. Is it already in use?", listener.readableName(), listener.getPort(), listener.getBindAddress());
    }
}

