/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;

public class NettyConfiguration {
    private final Class<? extends ServerSocketChannel> serverSocketChannelClass;
    private final Class<? extends SocketChannel> clientSocketChannelClass;
    private final EventLoopGroup parentEventLoopGroup;
    private final EventLoopGroup childEventLoopGroup;

    public NettyConfiguration(Class<? extends ServerSocketChannel> serverSocketChannelClass, Class<? extends SocketChannel> clientSocketChannelClass, EventLoopGroup parentEventLoopGroup, EventLoopGroup childEventLoopGroup) {
        Preconditions.checkNotNull(serverSocketChannelClass, (Object)"Server Socket Channel Class must not be null");
        Preconditions.checkNotNull(clientSocketChannelClass, (Object)"Client Socket Channel Class must not be null");
        Preconditions.checkNotNull((Object)parentEventLoopGroup, (Object)"Parent Event Loop Group must not be null");
        Preconditions.checkNotNull((Object)childEventLoopGroup, (Object)"Child Event Loop Group must not be null");
        this.serverSocketChannelClass = serverSocketChannelClass;
        this.clientSocketChannelClass = clientSocketChannelClass;
        this.parentEventLoopGroup = parentEventLoopGroup;
        this.childEventLoopGroup = childEventLoopGroup;
    }

    public Class<? extends ServerSocketChannel> getServerSocketChannelClass() {
        return this.serverSocketChannelClass;
    }

    public EventLoopGroup getParentEventLoopGroup() {
        return this.parentEventLoopGroup;
    }

    public EventLoopGroup getChildEventLoopGroup() {
        return this.childEventLoopGroup;
    }

    public Class<? extends SocketChannel> getClientSocketChannelClass() {
        return this.clientSocketChannelClass;
    }
}

