/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.netty.ChannelDependencies;
import com.hivemq.codec.decoder.MqttConnectDecoder;
import com.hivemq.codec.decoder.MqttDecoder;
import com.hivemq.codec.decoder.MqttDecoders;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.metrics.handler.GlobalMQTTMessageCounter;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.Message;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class MQTTMessageDecoder
extends ByteToMessageDecoder {
    private static final int MAX_REMAINING_LENGTH_MULTIPLIER = 0x200000;
    private static final int NOT_ENOUGH_BYTES_READABLE = -2;
    private static final int MALFORMED_REMAINING_LENGTH = -1;
    private static final int MIN_FIXED_HEADER_LENGTH = 2;
    @NotNull
    private final MqttConnectDecoder connectDecoder;
    @NotNull
    private final MqttConnacker mqttConnacker;
    @NotNull
    private final MqttConfigurationService mqttConfig;
    @NotNull
    private final MqttDecoders mqttDecoders;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;
    @NotNull
    private final GlobalMQTTMessageCounter globalMQTTMessageCounter;

    public MQTTMessageDecoder(@NotNull MqttConnectDecoder connectDecoder, @NotNull MqttConnacker mqttConnacker, @NotNull MqttConfigurationService mqttConfig, @NotNull MqttDecoders mqttDecoders, @NotNull MqttServerDisconnector mqttServerDisconnector, @NotNull GlobalMQTTMessageCounter globalMQTTMessageCounter) {
        this.connectDecoder = connectDecoder;
        this.mqttConnacker = mqttConnacker;
        this.mqttConfig = mqttConfig;
        this.mqttDecoders = mqttDecoders;
        this.mqttServerDisconnector = mqttServerDisconnector;
        this.globalMQTTMessageCounter = globalMQTTMessageCounter;
    }

    public MQTTMessageDecoder(ChannelDependencies channelDependencies) {
        this(channelDependencies.getMqttConnectDecoder(), channelDependencies.getMqttConnacker(), channelDependencies.getConfigurationService().mqttConfiguration(), channelDependencies.getMqttDecoders(), channelDependencies.getMqttServerDisconnector(), channelDependencies.getGlobalMQTTMessageCounter());
    }

    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf buf, @NotNull List<Object> out) {
        int readableBytes = buf.readableBytes();
        if (readableBytes < 2) {
            return;
        }
        buf.markReaderIndex();
        byte fixedHeader = buf.readByte();
        int remainingLength = MQTTMessageDecoder.calculateRemainingLength(buf);
        if (remainingLength == -2) {
            buf.resetReaderIndex();
            return;
        }
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        if (remainingLength == -1) {
            this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a message but the remaining length was malformed. Disconnecting client.", "Sent a message with invalid remaining length", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, "Message with a malformed remaining length was sent.", Mqtt5UserProperties.NO_USER_PROPERTIES, false, true);
            buf.clear();
            return;
        }
        if (buf.readableBytes() < remainingLength) {
            buf.resetReaderIndex();
            return;
        }
        int fixedHeaderSize = MQTTMessageDecoder.getFixedHeaderSize(remainingLength);
        int packetSize = fixedHeaderSize + remainingLength;
        MessageType messageType = MQTTMessageDecoder.getMessageType(fixedHeader);
        Message message = messageType == MessageType.CONNECT ? this.handleConnect(buf, clientConnectionContext, fixedHeader, packetSize, remainingLength) : this.handleMessage(buf, clientConnectionContext, fixedHeader, messageType, packetSize, remainingLength);
        if (message == null) {
            buf.clear();
            return;
        }
        this.globalMQTTMessageCounter.countInbound(message);
        out.add(message);
    }

    @Nullable
    private Message handleConnect(@NotNull ByteBuf buf, @NotNull ClientConnectionContext clientConnectionContext, byte fixedHeader, int packetSize, int remainingLength) {
        if (packetSize > this.mqttConfig.maxPacketSize()) {
            this.connectDecoder.decodeProtocolVersion(clientConnectionContext, buf);
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) connect packet exceeded the maximum permissible size.", "Sent CONNECT exceeded the maximum permissible size", Mqtt5ConnAckReasonCode.PACKET_TOO_LARGE, "Sent CONNECT exceeded the maximum permissible size.");
            return null;
        }
        if (clientConnectionContext.getProtocolVersion() != null) {
            this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent second CONNECT message. This is not allowed. Disconnecting client.", "Sent second CONNECT message", null, null, Mqtt5UserProperties.NO_USER_PROPERTIES, false, true);
            return null;
        }
        this.globalMQTTMessageCounter.countInboundTraffic(packetSize);
        ByteBuf messageBuffer = buf.readSlice(remainingLength);
        buf.markReaderIndex();
        return this.connectDecoder.decode(clientConnectionContext, messageBuffer, fixedHeader);
    }

    @Nullable
    private Message handleMessage(@NotNull ByteBuf buf, @NotNull ClientConnectionContext clientConnectionContext, byte fixedHeader, @NotNull MessageType messageType, int packetSize, int remainingLength) {
        ProtocolVersion protocolVersion = clientConnectionContext.getProtocolVersion();
        if (packetSize > this.mqttConfig.maxPacketSize()) {
            boolean forceClose = protocolVersion != ProtocolVersion.MQTTv5;
            this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a message, that was bigger than the maximum message size. Disconnecting client.", "Sent a message that was bigger than the maximum size", Mqtt5DisconnectReasonCode.PACKET_TOO_LARGE, "Size of the message sent was too large.", Mqtt5UserProperties.NO_USER_PROPERTIES, false, forceClose);
            return null;
        }
        if (protocolVersion == null) {
            this.mqttServerDisconnector.logAndClose(clientConnectionContext.getChannel(), "A client (IP: {}) sent other message before CONNECT. Disconnecting client.", "Sent other message before CONNECT");
            return null;
        }
        this.globalMQTTMessageCounter.countInboundTraffic(packetSize);
        ByteBuf messageBuffer = buf.readSlice(remainingLength);
        buf.markReaderIndex();
        MqttDecoder<?> decoder = this.mqttDecoders.decoder(messageType, protocolVersion);
        if (decoder != null) {
            return decoder.decode(clientConnectionContext, messageBuffer, fixedHeader);
        }
        switch (messageType) {
            case RESERVED_ZERO: {
                this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a message with an invalid message type '0'. This message type is reserved. Disconnecting client.", "Sent a message with message type '0'", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "Message type '0' is not allowed.");
                return null;
            }
            case CONNACK: {
                this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNACK message. This is invalid because clients are not allowed to send CONNACKs. Disconnecting client.", "Sent a CONNACK message", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "CONNACK message type is not allowed.");
                return null;
            }
            case SUBACK: {
                this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBACK message. This is invalid because clients are not allowed to send SUBACKs. Disconnecting client.", "Sent a SUBACK message", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBACK message type is not allowed.");
                return null;
            }
            case UNSUBACK: {
                this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a UNSUBACK message. This is invalid because clients are not allowed to send UNSUBACKs. Disconnecting client.", "Sent a UNSUBACK message", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "UNSUBACK message type is not allowed.");
                return null;
            }
            case PINGRESP: {
                this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PINGRESP message. This is invalid because clients are not allowed to send PINGRESPs. Disconnecting client.", "Sent a PINGRESP message", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PINGRESP message type is not allowed.");
                return null;
            }
            case AUTH: {
                this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a message with an invalid message type '15'. This message type is reserved. Disconnecting client.", "Sent a message with message type '15'", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "Message type '15' is not allowed.");
                return null;
            }
        }
        this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) connected but the message type could not get determined. Disconnecting client.", "Sent a message with invalid message type", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "Message type invalid.");
        return null;
    }

    private static int getFixedHeaderSize(int remainingLength) {
        int remainingLengthSize = 2;
        if (remainingLength > 127) {
            ++remainingLengthSize;
        }
        if (remainingLength > 16383) {
            ++remainingLengthSize;
        }
        if (remainingLength > 0x1FFFFF) {
            ++remainingLengthSize;
        }
        return remainingLengthSize;
    }

    private static int calculateRemainingLength(@NotNull ByteBuf buf) {
        byte encodedByte;
        int remainingLength = 0;
        int multiplier = 1;
        do {
            if (multiplier > 0x200000) {
                buf.skipBytes(buf.readableBytes());
                return -1;
            }
            if (!buf.isReadable()) {
                return -2;
            }
            encodedByte = buf.readByte();
            remainingLength += (encodedByte & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((encodedByte & 0x80) != 0);
        return remainingLength;
    }

    @NotNull
    private static MessageType getMessageType(byte fixedHeader) {
        return MessageType.valueOf((fixedHeader & 0xF0) >> 4);
    }
}

