/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt3;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttPublishDecoder;
import com.hivemq.configuration.HivemqId;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.publish.Mqtt3PUBLISH;
import com.hivemq.mqtt.message.publish.PUBLISHFactory;
import com.hivemq.util.Strings;
import io.netty.buffer.ByteBuf;

@LazySingleton
public class Mqtt3PublishDecoder
extends AbstractMqttPublishDecoder<Mqtt3PUBLISH> {
    @NotNull
    private final HivemqId hivemqId;

    @Inject
    public Mqtt3PublishDecoder(@NotNull HivemqId hivemqId, @NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
        this.hivemqId = hivemqId;
    }

    @Override
    @Nullable
    public Mqtt3PUBLISH decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        int packetIdentifier;
        String topicName;
        int qos = this.decodeQoS(clientConnectionContext, header);
        if (qos == -1) {
            return null;
        }
        Boolean dup = this.decodeDup(clientConnectionContext, header, qos);
        if (dup == null) {
            return null;
        }
        Boolean retain = this.decodeRetain(clientConnectionContext, header);
        if (retain == null) {
            return null;
        }
        int utf8StringLength = this.decodeUTF8StringLength(clientConnectionContext, buf, "topic", MessageType.PUBLISH);
        if (utf8StringLength == -1) {
            return null;
        }
        if (this.validateUTF8) {
            topicName = this.decodeUTF8Topic(clientConnectionContext, buf, utf8StringLength, "topic", MessageType.PUBLISH);
            if (topicName == null) {
                return null;
            }
        } else {
            topicName = Strings.getPrefixedString(buf, utf8StringLength);
        }
        if (this.topicInvalid(clientConnectionContext, "topic", topicName)) {
            return null;
        }
        if (qos > 0) {
            packetIdentifier = this.decodePacketIdentifier(clientConnectionContext, buf);
            if (packetIdentifier == 0) {
                return null;
            }
        } else {
            packetIdentifier = 0;
        }
        byte[] payload = new byte[buf.readableBytes()];
        buf.readBytes(payload);
        return new PUBLISHFactory.Mqtt3Builder().withHivemqId(this.hivemqId.get()).withMessageExpiryInterval(this.maxMessageExpiryInterval).withQoS(QoS.valueOf(qos)).withOnwardQos(QoS.valueOf(qos)).withTopic(topicName).withDuplicateDelivery(dup).withPacketIdentifier(packetIdentifier).withRetain(retain).withPayload(payload).build();
    }
}

