/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt5;

import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.unsubscribe.UNSUBSCRIBE;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.inject.Inject;

@LazySingleton
public class Mqtt5UnsubscribeDecoder
extends AbstractMqttDecoder<UNSUBSCRIBE> {
    @Inject
    public Mqtt5UnsubscribeDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public UNSUBSCRIBE decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        int readPropertyLength;
        if ((header & 0xF) != 2) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.UNSUBSCRIBE);
            return null;
        }
        if (buf.readableBytes() < 2) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.UNSUBSCRIBE);
            return null;
        }
        int packetIdentifier = this.decodePacketIdentifier(clientConnectionContext, buf);
        if (packetIdentifier == 0) {
            return null;
        }
        int propertiesLength = MqttVariableByteInteger.decode(buf);
        if (this.propertiesLengthInvalid(clientConnectionContext, buf, propertiesLength)) {
            return null;
        }
        ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder = null;
        int propertiesStartIndex = buf.readerIndex();
        while ((readPropertyLength = buf.readerIndex() - propertiesStartIndex) < propertiesLength) {
            byte propertyIdentifier = buf.readByte();
            if (propertyIdentifier == 38) {
                if ((userPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, userPropertiesBuilder, MessageType.UNSUBSCRIBE)) != null) continue;
                return null;
            }
            this.disconnectByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier, MessageType.UNSUBSCRIBE);
            return null;
        }
        if (readPropertyLength != propertiesLength) {
            this.disconnectByMalformedPropertyLength(clientConnectionContext, MessageType.UNSUBSCRIBE);
            return null;
        }
        if (!buf.isReadable()) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent an UNSUBSCRIBE without topic filters. This is not allowed. Disconnecting client.", "Sent UNSUBSCRIBE without topic filters", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "UNSUBSCRIBE containing no topic filters was sent. This is a protocol violation.");
            return null;
        }
        ImmutableList.Builder<String> topicFilterBuilder = null;
        while (buf.isReadable()) {
            if ((topicFilterBuilder = this.decodeTopicFilter(clientConnectionContext, buf, topicFilterBuilder)) != null) continue;
            return null;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(userPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, MessageType.UNSUBSCRIBE, userProperties)) {
            return null;
        }
        return new UNSUBSCRIBE((ImmutableList<String>)Objects.requireNonNull(topicFilterBuilder).build(), packetIdentifier, userProperties);
    }

    private int decodePacketIdentifier(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf) {
        int packetIdentifier = buf.readUnsignedShort();
        if (packetIdentifier == 0) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent an UNSUBSCRIBE with message id = '0'. This is not allowed. Disconnecting client.", "Sent UNSUBSCRIBE with message id = '0'", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "UNSUBSCRIBE with a packet identifier of '0' was sent. This is a protocol violation.");
        }
        return packetIdentifier;
    }

    private boolean propertiesLengthInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int propertyLength) {
        if (propertyLength < 0) {
            this.disconnectByMalformedPropertyLength(clientConnectionContext, MessageType.UNSUBSCRIBE);
            return true;
        }
        if (buf.readableBytes() < propertyLength) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.UNSUBSCRIBE);
            return true;
        }
        return false;
    }

    @Nullable
    private ImmutableList.Builder<String> decodeTopicFilter(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable ImmutableList.Builder<String> topicFilterBuilder) {
        String topicFilter = this.decodeUTF8Topic(clientConnectionContext, buf, "topic filter", MessageType.UNSUBSCRIBE);
        if (topicFilter == null) {
            return null;
        }
        if (topicFilterBuilder == null) {
            topicFilterBuilder = new ImmutableList.Builder();
        }
        return topicFilterBuilder.add((Object)topicFilter);
    }
}

