/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt3;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.MqttEncoder;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import io.netty.buffer.ByteBuf;

public class Mqtt3PubrelEncoder
implements MqttEncoder<PUBREL> {
    public static final int ENCODED_PUBREL_SIZE = 4;
    private static final byte PUBREL_FIXED_HEADER = 98;
    private static final byte PUBREL_REMAINING_LENGTH = 2;

    @Override
    public void encode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull PUBREL msg, @NotNull ByteBuf out) {
        if (msg.getPacketIdentifier() == 0) {
            throw new IllegalArgumentException("Message ID must not be null");
        }
        out.writeByte(98);
        out.writeByte(2);
        out.writeShort(msg.getPacketIdentifier());
    }

    @Override
    public int bufferSize(@NotNull ClientConnectionContext clientConnectionContext, @NotNull PUBREL msg) {
        return 4;
    }
}

