/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt5;

import com.google.common.base.Preconditions;
import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.reason.Mqtt5UnsubAckReasonCode;
import com.hivemq.mqtt.message.unsuback.UNSUBACK;
import io.netty.buffer.ByteBuf;
import javax.inject.Singleton;

@Singleton
public class Mqtt5UnsubackEncoder
extends Mqtt5MessageWithUserPropertiesEncoder.Mqtt5MessageWithReasonStringEncoder<UNSUBACK> {
    private static final int FIXED_HEADER = MessageType.UNSUBACK.ordinal() << 4;

    public Mqtt5UnsubackEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
        super(messageDroppedService, securityConfigurationService);
    }

    @Override
    void encode(@NotNull UNSUBACK unsuback, @NotNull ByteBuf out) {
        Preconditions.checkNotNull((Object)unsuback, (Object)"Unsuback must not be null.");
        Preconditions.checkNotNull((Object)out, (Object)"ByteBuf must not be null.");
        Mqtt5UnsubackEncoder.encodeFixedHeader(out, unsuback.getRemainingLength());
        this.encodeVariableHeader(unsuback, out);
        Mqtt5UnsubackEncoder.encodePayload(unsuback, out);
    }

    @Override
    int calculateRemainingLengthWithoutProperties(@NotNull UNSUBACK message) {
        return message.getReasonCodes().size() + 2;
    }

    @Override
    int calculatePropertyLength(@NotNull UNSUBACK message) {
        return this.omissiblePropertiesLength(message);
    }

    private void encodeVariableHeader(@NotNull UNSUBACK message, @NotNull ByteBuf out) {
        out.writeShort(message.getPacketIdentifier());
        MqttVariableByteInteger.encode(message.getPropertyLength(), out);
        this.encodeOmissibleProperties(message, out);
    }

    private static void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        out.writeByte(FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private static void encodePayload(@NotNull UNSUBACK message, @NotNull ByteBuf out) {
        for (Mqtt5UnsubAckReasonCode mqtt5SubAckReasonCode : message.getReasonCodes()) {
            out.writeByte(mqtt5SubAckReasonCode.getCode());
        }
    }
}

