/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.reader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.entity.listener.ListenerEntity;
import com.hivemq.configuration.entity.listener.TCPListenerEntity;
import com.hivemq.configuration.entity.listener.TLSEntity;
import com.hivemq.configuration.entity.listener.TlsTCPListenerEntity;
import com.hivemq.configuration.entity.listener.TlsWebsocketListenerEntity;
import com.hivemq.configuration.entity.listener.WebsocketListenerEntity;
import com.hivemq.configuration.entity.listener.tls.ClientAuthenticationModeEntity;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.configuration.service.entity.TcpListener;
import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.configuration.service.entity.TlsTcpListener;
import com.hivemq.configuration.service.entity.TlsWebsocketListener;
import com.hivemq.configuration.service.entity.WebsocketListener;
import com.hivemq.configuration.service.impl.listener.ListenerConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerConfigurator {
    private static final Logger log = LoggerFactory.getLogger(ListenerConfigurator.class);
    private static final String JKS = "JKS";
    @NotNull
    private final ListenerConfigurationService listenerConfigurationService;
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final List<String> chosenNames;

    public ListenerConfigurator(@NotNull ListenerConfigurationService listenerConfigurationService, @NotNull SystemInformation systemInformation) {
        this.listenerConfigurationService = listenerConfigurationService;
        this.systemInformation = systemInformation;
        this.chosenNames = new ArrayList<String>();
    }

    void setListenerConfig(@NotNull List<ListenerEntity> entities) {
        ImmutableList<Listener> listeners = this.convertListenerEntities(entities);
        for (Listener listener : listeners) {
            this.listenerConfigurationService.addListener(listener);
        }
    }

    @NotNull
    private ImmutableList<Listener> convertListenerEntities(@NotNull List<ListenerEntity> entities) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ListenerEntity entity : entities) {
            Listener listener = this.convertListener(entity);
            if (listener == null) continue;
            builder.add((Object)listener);
        }
        return builder.build();
    }

    @Nullable
    Listener convertListener(@NotNull ListenerEntity entity) {
        if (entity instanceof TCPListenerEntity) {
            return this.convertTcpListener((TCPListenerEntity)entity);
        }
        if (entity instanceof WebsocketListenerEntity) {
            return this.convertWebsocketListener((WebsocketListenerEntity)entity);
        }
        if (entity instanceof TlsTCPListenerEntity) {
            return this.convertTlsTcpListener((TlsTCPListenerEntity)entity);
        }
        if (entity instanceof TlsWebsocketListenerEntity) {
            return this.convertTlsWebsocketListener((TlsWebsocketListenerEntity)entity);
        }
        return null;
    }

    @NotNull
    TcpListener convertTcpListener(@NotNull TCPListenerEntity entity) {
        return new TcpListener(entity.getPort(), entity.getBindAddress(), this.getName(entity, "tcp-listener-"));
    }

    @NotNull
    WebsocketListener convertWebsocketListener(@NotNull WebsocketListenerEntity entity) {
        return new WebsocketListener.Builder().allowExtensions(entity.isAllowExtensions()).bindAddress(entity.getBindAddress()).path(entity.getPath()).port(entity.getPort()).subprotocols(entity.getSubprotocols()).name(this.getName(entity, "websocket-listener-")).build();
    }

    @NotNull
    TlsTcpListener convertTlsTcpListener(@NotNull TlsTCPListenerEntity entity) {
        return new TlsTcpListener(entity.getPort(), entity.getBindAddress(), this.convertTls(entity.getTls()), this.getName(entity, "tls-tcp-listener-"));
    }

    @NotNull
    TlsWebsocketListener convertTlsWebsocketListener(@NotNull TlsWebsocketListenerEntity entity) {
        return new TlsWebsocketListener.Builder().port(entity.getPort()).bindAddress(entity.getBindAddress()).path(entity.getPath()).allowExtensions(entity.isAllowExtensions()).tls(this.convertTls(entity.getTls())).subprotocols(entity.getSubprotocols()).name(this.getName(entity, "tls-websocket-listener-")).build();
    }

    @NotNull
    private String getName(@NotNull ListenerEntity entity, @NotNull String defaultPrefix) {
        String chosenName;
        String string = chosenName = entity.getName() == null || entity.getName().trim().isEmpty() ? defaultPrefix + entity.getPort() : entity.getName();
        if (this.chosenNames.contains(chosenName)) {
            int count = 1;
            String newName = chosenName + "-" + count++;
            while (this.chosenNames.contains(newName)) {
                newName = chosenName + "-" + count++;
            }
            log.warn("Name '{}' already in use. Renaming listener with address '{}' and port '{}' to: '{}'", new Object[]{chosenName, entity.getBindAddress(), entity.getPort(), newName});
            this.chosenNames.add(newName);
            return newName;
        }
        this.chosenNames.add(chosenName);
        return chosenName;
    }

    @NotNull
    Tls convertTls(@NotNull TLSEntity entity) {
        String keystorePath = this.getPathFromEntityPath(entity.getKeystoreEntity().getPath());
        String truststorePath = this.getPathFromEntityPath(entity.getTruststoreEntity().getPath());
        Preconditions.checkNotNull((Object)keystorePath, (Object)"Keystore path must not be null");
        return new Tls.Builder().withKeystorePath(keystorePath).withKeystoreType(JKS).withKeystorePassword(entity.getKeystoreEntity().getPassword()).withPrivateKeyPassword(entity.getKeystoreEntity().getPrivateKeyPassword()).withProtocols(entity.getProtocols()).withTruststorePath(truststorePath).withTruststoreType(JKS).withTruststorePassword(entity.getTruststoreEntity().getPassword()).withClientAuthMode(this.getClientAuthMode(entity.getClientAuthMode())).withCipherSuites(entity.getCipherSuites()).withPreferServerCipherSuites(entity.isPreferServerCipherSuites()).withHandshakeTimeout(entity.getHandshakeTimeout()).build();
    }

    @Nullable
    private String getPathFromEntityPath(@NotNull String path) {
        if (path.isBlank()) {
            return null;
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        return new File(this.systemInformation.getHiveMQHomeFolder(), path).getAbsolutePath();
    }

    @NotNull
    Tls.ClientAuthMode getClientAuthMode(@NotNull ClientAuthenticationModeEntity entity) {
        switch (entity) {
            case OPTIONAL: {
                return Tls.ClientAuthMode.OPTIONAL;
            }
            case REQUIRED: {
                return Tls.ClientAuthMode.REQUIRED;
            }
            case NONE: {
                return Tls.ClientAuthMode.NONE;
            }
        }
        return Tls.ClientAuthMode.NONE;
    }
}

