/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.diagnostic.data;

import com.hivemq.diagnostic.data.HiveMQInformation;
import com.hivemq.diagnostic.data.HiveMQSystemInformation;
import com.hivemq.diagnostic.data.NetworkInterfaceInformation;
import com.hivemq.diagnostic.data.SystemPropertyInformation;
import java.time.LocalDateTime;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class DiagnosticData {
    private static final String BANNER = "   __ ___          __  _______     ___  _                         __  _       \n  / // (_)  _____ /  |/  / __ \\   / _ \\(_)__ ____ ____  ___  ___ / /_(_)______\n / _  / / |/ / -_) /|_/ / /_/ /  / // / / _ `/ _ `/ _ \\/ _ \\(_-</ __/ / __(_-<\n/_//_/_/|___/\\__/_/  /_/\\___\\_\\ /____/_/\\_,_/\\_, /_//_/\\___/___/\\__/_/\\__/___/\n                                            /___/                             \n";
    private static final String SECTION_HEADLINE = "##############################\n";
    private final SystemPropertyInformation systemPropertyInformation;
    private final HiveMQInformation hiveMQInformation;
    private final HiveMQSystemInformation systemInformation;
    private final NetworkInterfaceInformation networkInterfaceInformation;

    @Inject
    DiagnosticData(SystemPropertyInformation systemPropertyInformation, HiveMQInformation hiveMQInformation, HiveMQSystemInformation systemInformation, NetworkInterfaceInformation networkInterfaceInformation) {
        this.systemPropertyInformation = systemPropertyInformation;
        this.hiveMQInformation = hiveMQInformation;
        this.systemInformation = systemInformation;
        this.networkInterfaceInformation = networkInterfaceInformation;
    }

    public String get() {
        StringBuilder diagnosticWriter = new StringBuilder();
        diagnosticWriter.append(BANNER);
        diagnosticWriter.append("\n");
        diagnosticWriter.append(String.format("Generated at %s \n", LocalDateTime.now().toString()));
        diagnosticWriter.append("Please send this file along with any other files in the 'diagnostic' folder to support@hivemq.com.\n\n");
        diagnosticWriter.append(this.createHeadline("HiveMQ Information"));
        diagnosticWriter.append(this.hiveMQInformation.getHiveMQInformation());
        diagnosticWriter.append(this.createHeadline("Java System Properties"));
        diagnosticWriter.append(this.systemPropertyInformation.getSystemPropertyInformation());
        diagnosticWriter.append(this.createHeadline("System Information"));
        diagnosticWriter.append(this.systemInformation.getSystemInformation());
        diagnosticWriter.append(this.createHeadline("Network Interfaces"));
        diagnosticWriter.append(this.networkInterfaceInformation.getNetworkInterfaceInformation());
        return diagnosticWriter.toString();
    }

    private String createHeadline(String text) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append(SECTION_HEADLINE);
        builder.append("#");
        builder.append(StringUtils.center((String)text, (int)(SECTION_HEADLINE.length() - 3)));
        builder.append("#\n");
        builder.append(SECTION_HEADLINE);
        builder.append("\n");
        return builder.toString();
    }
}

