/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.auth.parameter.AuthenticatorProviderInput;
import com.hivemq.extensions.auth.AuthOutput;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginTaskInput;
import com.hivemq.extensions.services.auth.WrappedAuthenticatorProvider;
import com.hivemq.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAuthTask<I extends PluginTaskInput, O extends AuthOutput<?>>
implements PluginInOutTask<I, O> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthTask.class);
    @NotNull
    final WrappedAuthenticatorProvider wrappedAuthenticatorProvider;
    @NotNull
    final AuthenticatorProviderInput authenticatorProviderInput;
    @NotNull
    final String extensionId;

    AbstractAuthTask(@NotNull WrappedAuthenticatorProvider wrappedAuthenticatorProvider, @NotNull AuthenticatorProviderInput authenticatorProviderInput, @NotNull String extensionId) {
        this.wrappedAuthenticatorProvider = wrappedAuthenticatorProvider;
        this.authenticatorProviderInput = authenticatorProviderInput;
        this.extensionId = extensionId;
    }

    @Override
    @NotNull
    public O apply(@NotNull I input, @NotNull O output) {
        if (((AuthOutput)output).getAuthenticationState().isFinal()) {
            return output;
        }
        try {
            this.call(input, output);
        }
        catch (Throwable throwable) {
            ((AuthOutput)output).failByThrowable(throwable);
            Exceptions.rethrowError(throwable);
            log.warn("Uncaught exception was thrown from extension with id \"{}\" in authenticator. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)throwable);
        }
        return output;
    }

    abstract void call(@NotNull I var1, @NotNull O var2);

    @Override
    @NotNull
    public ClassLoader getPluginClassLoader() {
        return this.wrappedAuthenticatorProvider.getClassLoader();
    }
}

