/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.client.parameter;

import com.google.common.collect.ImmutableSet;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.service.impl.listener.ListenerConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.Listener;
import com.hivemq.extension.sdk.api.client.parameter.ServerInformation;
import com.hivemq.extensions.client.parameter.ListenerImpl;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

@LazySingleton
public class ServerInformationImpl
implements ServerInformation {
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final ListenerConfigurationService listenerConfigurationService;

    @Inject
    public ServerInformationImpl(@NotNull SystemInformation systemInformation, @NotNull ListenerConfigurationService listenerConfigurationService) {
        this.systemInformation = systemInformation;
        this.listenerConfigurationService = listenerConfigurationService;
    }

    @NotNull
    public String getVersion() {
        return this.systemInformation.getHiveMQVersion();
    }

    @NotNull
    public File getHomeFolder() {
        return this.systemInformation.getHiveMQHomeFolder();
    }

    @NotNull
    public File getDataFolder() {
        return this.systemInformation.getDataFolder();
    }

    @NotNull
    public File getLogFolder() {
        return this.systemInformation.getLogFolder();
    }

    @NotNull
    public File getExtensionsFolder() {
        return this.systemInformation.getExtensionsFolder();
    }

    @NotNull
    public Set<Listener> getListener() {
        List<com.hivemq.configuration.service.entity.Listener> listeners = this.listenerConfigurationService.getListeners();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (com.hivemq.configuration.service.entity.Listener listener : listeners) {
            builder.add((Object)new ListenerImpl(listener));
        }
        return builder.build();
    }
}

