/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.executor.task;

import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.Async;
import com.hivemq.extensions.executor.task.PluginTaskOutput;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AsyncOutputImpl<T extends PluginTaskOutput>
implements Async<T> {
    @NotNull
    private final T output;
    @NotNull
    private final SettableFuture<Boolean> asyncFuture;
    @NotNull
    private final ScheduledFuture<?> timeoutTaskFuture;
    @NotNull
    private Async.Status status;

    public AsyncOutputImpl(@NotNull T output, @NotNull SettableFuture<Boolean> asyncFuture, @NotNull ScheduledFuture<?> timeoutTaskFuture) {
        this.output = output;
        this.asyncFuture = asyncFuture;
        this.timeoutTaskFuture = timeoutTaskFuture;
        this.status = Async.Status.RUNNING;
    }

    public void resume() {
        this.timeoutTaskFuture.cancel(true);
        this.status = Async.Status.DONE;
        this.asyncFuture.set((Object)true);
    }

    @NotNull
    public T getOutput() {
        return this.output;
    }

    @NotNull
    public Async.Status getStatus() {
        if (this.asyncFuture.isDone()) {
            try {
                return (Boolean)this.asyncFuture.get(1L, TimeUnit.SECONDS) != false ? Async.Status.DONE : Async.Status.CANCELED;
            }
            catch (Exception e) {
                return Async.Status.CANCELED;
            }
        }
        return this.status;
    }
}

