/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.executor.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Striped;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extensions.executor.task.DefaultPluginTaskOutput;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInTask;
import com.hivemq.extensions.executor.task.PluginOutTask;
import com.hivemq.extensions.executor.task.PluginTask;
import com.hivemq.extensions.executor.task.PluginTaskContext;
import com.hivemq.extensions.executor.task.PluginTaskExecution;
import com.hivemq.extensions.executor.task.PluginTaskOutput;
import com.hivemq.extensions.executor.task.PluginTaskPost;
import com.hivemq.extensions.ioc.annotation.PluginTaskQueue;
import com.hivemq.util.Exceptions;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

@ThreadSafe
public class PluginTaskExecutor {
    @NotNull
    private static final AtomicInteger COUNTER = new AtomicInteger();
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final AtomicBoolean running = new AtomicBoolean(true);
    @NotNull
    private final ConcurrentMap<String, Queue<PluginTaskExecution>> taskQueues = new ConcurrentHashMap<String, Queue<PluginTaskExecution>>();
    @NotNull
    private final AtomicLong counterAllQueues;
    @NotNull
    private final Semaphore semaphore = new Semaphore(0);
    @NotNull
    private final Striped<Lock> stripedLock = Striped.lock((int)100);

    @Inject
    public PluginTaskExecutor(@PluginTaskQueue @NotNull AtomicLong counterAllQueues) {
        this.counterAllQueues = counterAllQueues;
        this.executorService = Executors.newSingleThreadExecutor(ThreadFactoryUtil.create("extension-task-executor-" + COUNTER.getAndIncrement()));
    }

    @PostConstruct
    @VisibleForTesting
    public void postConstruct() {
        this.executorService.submit(new PluginTaskExecutorRunnable());
    }

    public void stop() {
        this.running.set(false);
        this.executorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePluginTaskExecution(@NotNull PluginTaskExecution pluginTaskExecution) {
        if (!this.running.get()) {
            throw new RejectedExecutionException("Extension Task executor is already stopped");
        }
        this.counterAllQueues.getAndIncrement();
        String identifier = pluginTaskExecution.getPluginContext().getIdentifier();
        Lock lock = (Lock)this.stripedLock.get((Object)identifier);
        try {
            lock.lock();
            Queue<PluginTaskExecution> queueForId = this.taskQueues.computeIfAbsent(identifier, new CreateQueueIfNotPresent());
            queueForId.add(pluginTaskExecution);
        }
        finally {
            lock.unlock();
        }
        this.semaphore.release();
    }

    private class PluginTaskExecutorRunnable
    implements Runnable {
        private PluginTaskExecutorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PluginTaskExecutor.this.semaphore.acquire();
                while (PluginTaskExecutor.this.running.get()) {
                    boolean taskExecuted = false;
                    int availablePermitsBeforeLoop = PluginTaskExecutor.this.semaphore.availablePermits();
                    for (Map.Entry taskQueueEntry : PluginTaskExecutor.this.taskQueues.entrySet()) {
                        PluginTaskExecution task;
                        Queue queue = (Queue)taskQueueEntry.getValue();
                        String key = (String)taskQueueEntry.getKey();
                        if (queue.isEmpty() && this.possiblyCleanupEmptyQueue(key) || (task = (PluginTaskExecution)queue.peek()) == null) continue;
                        if (task.isAsync()) {
                            if (!task.isDone()) continue;
                            this.executeDoneTask(task);
                            queue.remove();
                            PluginTaskExecutor.this.counterAllQueues.decrementAndGet();
                            taskExecuted = true;
                            PluginTaskExecutor.this.semaphore.acquire();
                            continue;
                        }
                        try {
                            taskExecuted = true;
                            this.executeTask(task);
                            if (task.isAsync()) continue;
                            queue.remove();
                            PluginTaskExecutor.this.counterAllQueues.decrementAndGet();
                        }
                        catch (Throwable t) {
                            queue.remove();
                            PluginTaskExecutor.this.counterAllQueues.decrementAndGet();
                            Exceptions.rethrowError("Exception at extension task", t);
                        }
                        finally {
                            PluginTaskExecutor.this.semaphore.acquire();
                        }
                    }
                    if (taskExecuted) continue;
                    PluginTaskExecutor.this.semaphore.acquire(availablePermitsBeforeLoop + 1);
                    PluginTaskExecutor.this.semaphore.release(availablePermitsBeforeLoop + 1);
                }
            }
            catch (InterruptedException taskExecuted) {
            }
            catch (Throwable t) {
                Exceptions.rethrowError("Exception at PluginTaskExecutor", t);
            }
            finally {
                if (PluginTaskExecutor.this.running.get()) {
                    PluginTaskExecutor.this.executorService.submit(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean possiblyCleanupEmptyQueue(@NotNull String key) {
            Lock lock = (Lock)PluginTaskExecutor.this.stripedLock.get((Object)key);
            try {
                lock.lock();
                Queue possiblyEmptyQueue = (Queue)PluginTaskExecutor.this.taskQueues.get(key);
                if (possiblyEmptyQueue.isEmpty()) {
                    PluginTaskExecutor.this.taskQueues.remove(key);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                lock.unlock();
            }
            return false;
        }

        private void executeDoneTask(@NotNull PluginTaskExecution task) {
            try {
                Object outputObject = task.getOutputObject();
                if (outputObject == null) {
                    return;
                }
                PluginTaskContext pluginContext = task.getPluginContext();
                if (pluginContext instanceof PluginTaskPost) {
                    PluginTaskPost pluginPost = (PluginTaskPost)((Object)pluginContext);
                    pluginPost.pluginPost(outputObject);
                }
                if (outputObject.isAsync()) {
                    outputObject.resetAsyncStatus();
                }
            }
            catch (Throwable t) {
                Exceptions.rethrowError("Exception at extension post", t);
            }
        }

        private void executeTask(final @NotNull PluginTaskExecution task) {
            PluginTaskOutput output = this.runTask(task);
            task.setOutputObject(output);
            if (output.isAsync()) {
                task.markAsAsync();
                SettableFuture<Boolean> asyncFuture = output.getAsyncFuture();
                Preconditions.checkNotNull(asyncFuture, (Object)"Async future cannot be null for an async task");
                Futures.addCallback(asyncFuture, (FutureCallback)new FutureCallback<Boolean>(){

                    public void onSuccess(@Nullable Boolean result) {
                        task.markAsDone();
                        PluginTaskExecutor.this.semaphore.release();
                    }

                    public void onFailure(@NotNull Throwable t) {
                        Exceptions.rethrowError("Exception at PluginTaskExecutor", t);
                        task.markAsDone();
                        PluginTaskExecutor.this.semaphore.release();
                    }
                }, (Executor)MoreExecutors.directExecutor());
            } else {
                task.markAsDone();
                this.executeDoneTask(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private PluginTaskOutput runTask(@NotNull PluginTaskExecution task) {
            Thread thread = Thread.currentThread();
            ClassLoader contextClassLoader = thread.getContextClassLoader();
            try {
                PluginTaskOutput output;
                PluginTask pluginTask = task.getPluginTask();
                thread.setContextClassLoader(pluginTask.getPluginClassLoader());
                if (pluginTask instanceof PluginInOutTask) {
                    output = this.runInOutTask(task, (PluginInOutTask)pluginTask);
                } else if (pluginTask instanceof PluginInTask) {
                    output = this.runInTask(task, (PluginInTask)pluginTask);
                } else if (pluginTask instanceof PluginOutTask) {
                    output = this.runOutTask(task, (PluginOutTask)pluginTask);
                } else {
                    throw new IllegalArgumentException("Unknown task type for extension task queue");
                }
                PluginTaskOutput pluginTaskOutput = output;
                return pluginTaskOutput;
            }
            finally {
                thread.setContextClassLoader(contextClassLoader);
            }
        }

        @NotNull
        private PluginTaskOutput runOutTask(@NotNull PluginTaskExecution task, PluginOutTask pluginTask) {
            return (PluginTaskOutput)pluginTask.apply(task.getOutputObject());
        }

        @NotNull
        private PluginTaskOutput runInTask(@NotNull PluginTaskExecution task, @NotNull PluginInTask pluginTask) {
            pluginTask.accept(task.getInputObject());
            return DefaultPluginTaskOutput.getInstance();
        }

        @NotNull
        private PluginTaskOutput runInOutTask(@NotNull PluginTaskExecution task, PluginInOutTask pluginTask) {
            return (PluginTaskOutput)pluginTask.apply(task.getInputObject(), task.getOutputObject());
        }
    }

    private static class CreateQueueIfNotPresent
    implements Function<String, Queue<PluginTaskExecution>> {
        private CreateQueueIfNotPresent() {
        }

        @Override
        @NotNull
        public Queue<PluginTaskExecution> apply(@NotNull String id) {
            return new ConcurrentLinkedQueue<PluginTaskExecution>();
        }
    }
}

