/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.puback.PubackInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.puback.PubackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.puback.parameter.PubackInboundInput;
import com.hivemq.extension.sdk.api.interceptor.puback.parameter.PubackInboundOutput;
import com.hivemq.extension.sdk.api.interceptor.puback.parameter.PubackOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.puback.parameter.PubackOutboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.puback.parameter.PubackInboundInputImpl;
import com.hivemq.extensions.interceptor.puback.parameter.PubackInboundOutputImpl;
import com.hivemq.extensions.interceptor.puback.parameter.PubackOutboundInputImpl;
import com.hivemq.extensions.interceptor.puback.parameter.PubackOutboundOutputImpl;
import com.hivemq.extensions.packets.puback.ModifiablePubackPacketImpl;
import com.hivemq.extensions.packets.puback.PubackPacketImpl;
import com.hivemq.mqtt.message.puback.PUBACK;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PubackInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(PubackInterceptorHandler.class);
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginTaskExecutorService executorService;

    @Inject
    public PubackInterceptorHandler(@NotNull FullConfigurationService configurationService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginTaskExecutorService executorService) {
        this.configurationService = configurationService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.executorService = executorService;
    }

    public void handleInboundPuback(@NotNull ChannelHandlerContext ctx, @NotNull PUBACK puback) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.fireChannelRead((Object)puback);
            return;
        }
        List<PubackInboundInterceptor> interceptors = clientContext.getPubackInboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.fireChannelRead((Object)puback);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PubackPacketImpl packet = new PubackPacketImpl(puback);
        PubackInboundInputImpl input = new PubackInboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PubackInboundInputImpl> inputHolder = new ExtensionParameterHolder<PubackInboundInputImpl>(input);
        ModifiablePubackPacketImpl modifiablePacket = new ModifiablePubackPacketImpl(packet, this.configurationService);
        PubackInboundOutputImpl output = new PubackInboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PubackInboundOutputImpl> outputHolder = new ExtensionParameterHolder<PubackInboundOutputImpl>(output);
        PubackInboundInterceptorContext context = new PubackInboundInterceptorContext(clientId, interceptors.size(), ctx, inputHolder, outputHolder);
        for (PubackInboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PubackInboundInterceptorTask task = new PubackInboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    public void handleOutboundPuback(@NotNull ChannelHandlerContext ctx, @NotNull PUBACK puback, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.write((Object)puback, promise);
            return;
        }
        List<PubackOutboundInterceptor> interceptors = clientContext.getPubackOutboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.write((Object)puback, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PubackPacketImpl packet = new PubackPacketImpl(puback);
        PubackOutboundInputImpl input = new PubackOutboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PubackOutboundInputImpl> inputHolder = new ExtensionParameterHolder<PubackOutboundInputImpl>(input);
        ModifiablePubackPacketImpl modifiablePacket = new ModifiablePubackPacketImpl(packet, this.configurationService);
        PubackOutboundOutputImpl output = new PubackOutboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PubackOutboundOutputImpl> outputHolder = new ExtensionParameterHolder<PubackOutboundOutputImpl>(output);
        PubackOutboundInterceptorContext context = new PubackOutboundInterceptorContext(clientId, interceptors.size(), ctx, promise, inputHolder, outputHolder);
        for (PubackOutboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PubackOutboundInterceptorTask task = new PubackOutboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class PubackOutboundInterceptorTask
    implements PluginInOutTask<PubackOutboundInputImpl, PubackOutboundOutputImpl> {
        @NotNull
        private final PubackOutboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PubackOutboundInterceptorTask(@NotNull PubackOutboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PubackOutboundOutputImpl apply(@NotNull PubackOutboundInputImpl input, @NotNull PubackOutboundOutputImpl output) {
            try {
                this.interceptor.onOutboundPuback((PubackOutboundInput)input, (PubackOutboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound PUBACK interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class PubackOutboundInterceptorContext
    extends PluginInOutTaskContext<PubackOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;
        @NotNull
        private final ExtensionParameterHolder<PubackOutboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PubackOutboundOutputImpl> outputHolder;

        PubackOutboundInterceptorContext(@NotNull String clientId, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise, @NotNull ExtensionParameterHolder<PubackOutboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<PubackOutboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.promise = promise;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PubackOutboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on outbound PUBACK interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on outbound PUBACK interception. Discarding changes made by the interceptor.");
            } else if (output.getPubackPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.writeAndFlush((Object)PUBACK.from(this.inputHolder.get().getPubackPacket()), this.promise);
        }
    }

    private static class PubackInboundInterceptorTask
    implements PluginInOutTask<PubackInboundInputImpl, PubackInboundOutputImpl> {
        @NotNull
        private final PubackInboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PubackInboundInterceptorTask(@NotNull PubackInboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PubackInboundOutputImpl apply(@NotNull PubackInboundInputImpl input, @NotNull PubackInboundOutputImpl output) {
            try {
                this.interceptor.onInboundPuback((PubackInboundInput)input, (PubackInboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on inbound PUBACK interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class PubackInboundInterceptorContext
    extends PluginInOutTaskContext<PubackInboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ExtensionParameterHolder<PubackInboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PubackInboundOutputImpl> outputHolder;

        PubackInboundInterceptorContext(@NotNull String clientId, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ExtensionParameterHolder<PubackInboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<PubackInboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PubackInboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on inbound PUBACK interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on inbound PUBACK interception. Discarding changes made by the interceptor.");
            } else if (output.getPubackPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.fireChannelRead((Object)PUBACK.from(this.inputHolder.get().getPubackPacket()));
        }
    }
}

