/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler.tasks;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.auth.Authorizer;
import com.hivemq.extension.sdk.api.auth.PublishAuthorizer;
import com.hivemq.extension.sdk.api.auth.parameter.AuthorizerProviderInput;
import com.hivemq.extension.sdk.api.auth.parameter.PublishAuthorizerInput;
import com.hivemq.extension.sdk.api.auth.parameter.PublishAuthorizerOutput;
import com.hivemq.extension.sdk.api.services.auth.provider.AuthorizerProvider;
import com.hivemq.extensions.auth.parameter.PublishAuthorizerInputImpl;
import com.hivemq.extensions.auth.parameter.PublishAuthorizerOutputImpl;
import com.hivemq.extensions.client.ClientAuthorizers;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.util.Exceptions;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishAuthorizerTask
implements PluginInOutTask<PublishAuthorizerInputImpl, PublishAuthorizerOutputImpl> {
    private static final Logger log = LoggerFactory.getLogger(PublishAuthorizerTask.class);
    @NotNull
    private final AuthorizerProvider authorizerProvider;
    @NotNull
    private final AuthorizerProviderInput authorizerProviderInput;
    @NotNull
    private final String pluginId;
    @NotNull
    private final ClientAuthorizers clientAuthorizers;
    @NotNull
    private final ChannelHandlerContext channelHandlerContext;

    public PublishAuthorizerTask(@NotNull AuthorizerProvider authorizerProvider, @NotNull String pluginId, @NotNull AuthorizerProviderInput input, @NotNull ClientAuthorizers clientAuthorizers, @NotNull ChannelHandlerContext channelHandlerContext) {
        this.authorizerProvider = authorizerProvider;
        this.pluginId = pluginId;
        this.authorizerProviderInput = input;
        this.clientAuthorizers = clientAuthorizers;
        this.channelHandlerContext = channelHandlerContext;
    }

    @Override
    @NotNull
    public PublishAuthorizerOutputImpl apply(@NotNull PublishAuthorizerInputImpl input, @NotNull PublishAuthorizerOutputImpl output) {
        if (output.isCompleted()) {
            return output;
        }
        PublishAuthorizer authorizer = this.updateAndGetAuthorizer();
        if (authorizer == null) {
            return output;
        }
        output.authorizerPresent();
        if (ClientConnectionContext.of(this.channelHandlerContext.channel()).isIncomingPublishesSkipRest()) {
            output.forceFailedAuthorization();
        } else {
            try {
                authorizer.authorizePublish((PublishAuthorizerInput)input, (PublishAuthorizerOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" at subscription authorization. Extensions are responsible on their own to handle exceptions.", (Object)this.pluginId, (Object)e);
                Exceptions.rethrowError(e);
            }
        }
        return output;
    }

    @Nullable
    private PublishAuthorizer updateAndGetAuthorizer() {
        PublishAuthorizer authorizer = null;
        for (Map.Entry<String, PublishAuthorizer> authorizerEntry : this.clientAuthorizers.getPublishAuthorizersMap().entrySet()) {
            String pluginId = authorizerEntry.getKey();
            PublishAuthorizer publishAuthorizer = authorizerEntry.getValue();
            if (!publishAuthorizer.getClass().getClassLoader().equals(this.authorizerProvider.getClass().getClassLoader()) || !pluginId.equals(this.pluginId)) continue;
            authorizer = publishAuthorizer;
        }
        if (authorizer == null) {
            try {
                Authorizer authorizerProvided = this.authorizerProvider.getAuthorizer(this.authorizerProviderInput);
                if (authorizerProvided instanceof PublishAuthorizer) {
                    authorizer = (PublishAuthorizer)authorizerProvided;
                    this.clientAuthorizers.put(this.pluginId, (Authorizer)authorizer);
                }
            }
            catch (Throwable t) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" in authorizer provider. Extensions are responsible on their own to handle exceptions.", (Object)this.pluginId, (Object)t);
                Exceptions.rethrowError(t);
            }
        }
        return authorizer;
    }

    @Override
    @NotNull
    public ClassLoader getPluginClassLoader() {
        return this.authorizerProvider.getClass().getClassLoader();
    }
}

