/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.ioc;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class ExtensionStartStopExecutorProvider
implements Provider<ExecutorService> {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(ExtensionStartStopExecutorProvider.class);
    @NotNull
    private final ShutdownHooks shutdownHooks;

    @Inject
    public ExtensionStartStopExecutorProvider(@NotNull ShutdownHooks shutdownHooks) {
        this.shutdownHooks = shutdownHooks;
    }

    public ExecutorService get() {
        ThreadFactory threadFactory = ThreadFactoryUtil.create("extension-start-stop-executor");
        ExecutorService executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.shutdownHooks.add(new ExtensionStartStopExecutorShutdownHook(executorService));
        return executorService;
    }

    private static class ExtensionStartStopExecutorShutdownHook
    implements HiveMQShutdownHook {
        @NotNull
        private final ExecutorService executorService;

        private ExtensionStartStopExecutorShutdownHook(@NotNull ExecutorService executorService) {
            this.executorService = executorService;
        }

        @Override
        @NotNull
        public String name() {
            return "Extension Start Stop Executor";
        }

        @Override
        @NotNull
        public HiveMQShutdownHook.Priority priority() {
            return HiveMQShutdownHook.Priority.DOES_NOT_MATTER;
        }

        @Override
        public void run() {
            log.debug("Shutting down extension-start-stop-executor.");
            this.executorService.shutdown();
        }
    }
}

