/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.pubrel;

import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.pubrel.ModifiablePubrelPacket;
import com.hivemq.extension.sdk.api.packets.pubrel.PubrelReasonCode;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.pubrel.PubrelPacketImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import java.util.Objects;
import java.util.Optional;

public class ModifiablePubrelPacketImpl
implements ModifiablePubrelPacket {
    private final int packetIdentifier;
    @NotNull
    private final PubrelReasonCode reasonCode;
    @Nullable
    private String reasonString;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiablePubrelPacketImpl(@NotNull PubrelPacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.packetIdentifier = packet.packetIdentifier;
        this.reasonCode = packet.reasonCode;
        this.reasonString = packet.reasonString;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.configurationService = configurationService;
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public PubrelReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public void setReasonString(@Nullable String reasonString) {
        PluginBuilderUtil.checkReasonString(reasonString, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.reasonString, reasonString)) {
            return;
        }
        this.reasonString = reasonString;
        this.modified = true;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public PubrelPacketImpl copy() {
        return new PubrelPacketImpl(this.packetIdentifier, this.reasonCode, this.reasonString, this.userProperties.copy());
    }

    @NotNull
    public ModifiablePubrelPacketImpl update(@NotNull PubrelPacketImpl packet) {
        return new ModifiablePubrelPacketImpl(packet, this.configurationService);
    }
}

