/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.subscribe;

import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.packets.subscribe.ModifiableSubscribePacket;
import com.hivemq.extension.sdk.api.packets.subscribe.ModifiableSubscription;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.subscribe.ModifiableSubscriptionImpl;
import com.hivemq.extensions.packets.subscribe.SubscribePacketImpl;
import com.hivemq.extensions.packets.subscribe.SubscriptionImpl;
import java.util.Optional;

@ThreadSafe
public class ModifiableSubscribePacketImpl
implements ModifiableSubscribePacket {
    @NotNull
    private final ImmutableList<ModifiableSubscriptionImpl> subscriptions;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    private final int subscriptionIdentifier;
    private final int packetIdentifier;
    @NotNull
    private final FullConfigurationService configurationService;

    public ModifiableSubscribePacketImpl(@NotNull SubscribePacketImpl packet, @NotNull FullConfigurationService configurationService) {
        ImmutableList.Builder builder = ImmutableList.builder();
        packet.subscriptions.forEach(subscription -> builder.add((Object)new ModifiableSubscriptionImpl((SubscriptionImpl)subscription, configurationService)));
        this.subscriptions = builder.build();
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.subscriptionIdentifier = packet.subscriptionIdentifier;
        this.packetIdentifier = packet.packetIdentifier;
        this.configurationService = configurationService;
    }

    @NotNull
    public ImmutableList<ModifiableSubscription> getSubscriptions() {
        return ImmutableList.copyOf(this.subscriptions);
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    @NotNull
    public Optional<Integer> getSubscriptionIdentifier() {
        if (this.subscriptionIdentifier == -1) {
            return Optional.empty();
        }
        return Optional.of(this.subscriptionIdentifier);
    }

    public int getPacketId() {
        return this.packetIdentifier;
    }

    public boolean isModified() {
        for (ModifiableSubscription modifiableSubscription : this.subscriptions) {
            if (!((ModifiableSubscriptionImpl)modifiableSubscription).isModified()) continue;
            return true;
        }
        return this.userProperties.isModified();
    }

    @NotNull
    public SubscribePacketImpl copy() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.subscriptions.forEach(subscription -> builder.add((Object)subscription.copy()));
        return new SubscribePacketImpl((ImmutableList<SubscriptionImpl>)builder.build(), this.userProperties.copy(), this.subscriptionIdentifier, this.packetIdentifier);
    }

    @NotNull
    public ModifiableSubscribePacketImpl update(@NotNull SubscribePacketImpl packet) {
        return new ModifiableSubscribePacketImpl(packet, this.configurationService);
    }
}

