/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.unsubscribe;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.packets.unsubscribe.ModifiableUnsubscribePacket;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.unsubscribe.UnsubscribePacketImpl;
import java.util.List;
import java.util.Objects;

public class ModifiableUnsubscribePacketImpl
implements ModifiableUnsubscribePacket {
    @NotNull
    private ImmutableList<String> topicFilters;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    private final int packetIdentifier;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiableUnsubscribePacketImpl(@NotNull UnsubscribePacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.topicFilters = packet.topicFilters;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.packetIdentifier = packet.packetIdentifier;
        this.configurationService = configurationService;
    }

    @NotNull
    public ImmutableList<String> getTopicFilters() {
        return this.topicFilters;
    }

    public void setTopicFilters(@NotNull @NotNull List<@NotNull String> topicFilters) {
        Preconditions.checkNotNull(topicFilters, (Object)"Topic filters must never be null.");
        if (topicFilters.size() != this.topicFilters.size()) {
            throw new IllegalArgumentException("The amount of topic filters must not be changed.");
        }
        for (int i = 0; i < topicFilters.size(); ++i) {
            Preconditions.checkNotNull((Object)topicFilters.get(i), (String)"Topic filter (at index %s) must never be null.", (int)i);
        }
        if (Objects.equals(this.topicFilters, topicFilters)) {
            return;
        }
        this.topicFilters = ImmutableList.copyOf(topicFilters);
        this.modified = true;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public UnsubscribePacketImpl copy() {
        return new UnsubscribePacketImpl(this.topicFilters, this.userProperties.copy(), this.packetIdentifier);
    }

    @NotNull
    public ModifiableUnsubscribePacketImpl update(@NotNull UnsubscribePacketImpl packet) {
        return new ModifiableUnsubscribePacketImpl(packet, this.configurationService);
    }
}

