/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.logging.modifier;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.spi.FilterReply;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.logging.modifier.LogLevelModifier;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.EnvironmentImpl;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class XodusEnvironmentImplLogLevelModifier
implements LogLevelModifier {
    @NotNull
    private final Logger environmentalLogger;

    public XodusEnvironmentImplLogLevelModifier() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.environmentalLogger = context.getLogger(EnvironmentImpl.class);
    }

    @Override
    @NotNull
    public FilterReply decide(@Nullable Marker marker, @NotNull Logger logger, @NotNull Level level, @NotNull String format, @Nullable @Nullable Object @Nullable [] params, @Nullable Throwable t) {
        if (level.isGreaterOrEqual(Level.INFO)) {
            if (logger.equals(this.environmentalLogger)) {
                if (format.contains("transaction(s) not finished")) {
                    logger.trace(marker, format, params);
                    return FilterReply.DENY;
                }
                if (format.contains("Transactions stack traces are not available")) {
                    logger.trace(marker, format, params);
                    return FilterReply.DENY;
                }
            }
            if (level == Level.ERROR && t instanceof ExodusException && (t.getMessage().contains("cleanFile") || t.getMessage().contains("There is no file by address"))) {
                logger.trace(marker, "Xodus background job unable to cleanup stale data just now, trying again later");
                return FilterReply.DENY;
            }
        }
        return FilterReply.NEUTRAL;
    }
}

