/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.legacy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.persistence.legacy.PUBLISH_4_4;
import com.hivemq.migration.persistence.legacy.serializer.ClientQueuePersistenceSerializer_4_4;
import com.hivemq.mqtt.message.MessageWithID;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.clientqueue.ClientQueueEntry;
import com.hivemq.persistence.clientqueue.ClientQueuePersistenceImpl;
import com.hivemq.persistence.local.xodus.EnvironmentUtil;
import com.hivemq.persistence.local.xodus.XodusLocalPersistence;
import com.hivemq.persistence.local.xodus.bucket.Bucket;
import com.hivemq.util.LocalPersistenceFileUtil;
import com.hivemq.util.ThreadPreConditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class ClientQueueXodusLocalPersistence_4_4
extends XodusLocalPersistence {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(ClientQueueXodusLocalPersistence_4_4.class);
    private static final String PERSISTENCE_NAME = "client_queue";
    public static final String PERSISTENCE_VERSION = "040000";
    @NotNull
    @VisibleForTesting
    final ClientQueuePersistenceSerializer_4_4 serializer = new ClientQueuePersistenceSerializer_4_4();
    @NotNull
    @VisibleForTesting
    final ConcurrentHashMap<Integer, Map<ClientQueuePersistenceImpl.Key, AtomicInteger>> queueSizeBuckets = new ConcurrentHashMap();
    @NotNull
    @VisibleForTesting
    final ConcurrentHashMap<Integer, Map<ClientQueuePersistenceImpl.Key, AtomicInteger>> retainedQueueSizeBuckets = new ConcurrentHashMap();
    @NotNull
    @VisibleForTesting
    final ConcurrentHashMap<String, AtomicInteger> queueQos0MemoryMap = new ConcurrentHashMap();
    @NotNull
    @VisibleForTesting
    final ConcurrentHashMap<String, AtomicInteger> sharedSubscriptionSizes = new ConcurrentHashMap();

    @Inject
    ClientQueueXodusLocalPersistence_4_4(@NotNull EnvironmentUtil environmentUtil, @NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull PersistenceStartup persistenceStartup) {
        super(environmentUtil, localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get(), false);
    }

    @Override
    @NotNull
    protected String getName() {
        return PERSISTENCE_NAME;
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected StoreConfig getStoreConfig() {
        return StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    protected void init() {
    }

    public void add(@NotNull String queueId, boolean shared, @NotNull PUBLISH_4_4 publish, boolean retained, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        Preconditions.checkNotNull((Object)publish, (Object)"Publish must not be null");
        ThreadPreConditions.startsWith("single-writer");
        ClientQueuePersistenceImpl.Key key = new ClientQueuePersistenceImpl.Key(queueId, shared);
        Bucket bucket = this.buckets[bucketIndex];
        ByteIterable keyBytes = this.serializer.serializeNewPublishKey(key);
        ByteIterable valueBytes = this.serializer.serializePublishWithoutPacketId(publish, retained);
        bucket.getEnvironment().executeInTransaction(txn -> bucket.getStore().put(txn, keyBytes, valueBytes));
    }

    public void iterate(@NotNull QueueCallback_4_4 callback_4_4) {
        for (Bucket bucket : this.buckets) {
            bucket.getEnvironment().executeInReadonlyTransaction(txn -> {
                try (Cursor cursor = bucket.getStore().openCursor(txn);){
                    ClientQueuePersistenceImpl.Key currentKey = null;
                    ImmutableList.Builder builder = new ImmutableList.Builder();
                    while (cursor.getNext()) {
                        ByteIterable serializedKey = cursor.getKey();
                        ByteIterable serializedValue = cursor.getValue();
                        ClientQueuePersistenceImpl.Key key = this.serializer.deserializeKeyId(serializedKey);
                        if (currentKey == null) {
                            currentKey = key;
                        }
                        if (!currentKey.equals(key)) {
                            callback_4_4.onItem(currentKey, (ImmutableList<ClientQueueEntry>)builder.build());
                            builder = new ImmutableList.Builder();
                            currentKey = key;
                        }
                        MessageWithID message = this.serializer.deserializeValue(serializedValue);
                        boolean retained = this.serializer.deserializeRetained(serializedValue);
                        builder.add((Object)new ClientQueueEntry(message, retained));
                    }
                    ImmutableList build = builder.build();
                    if (!build.isEmpty() && currentKey != null) {
                        callback_4_4.onItem(currentKey, (ImmutableList<ClientQueueEntry>)build);
                    }
                }
            });
        }
    }

    public static interface QueueCallback_4_4 {
        public void onItem(@NotNull ClientQueuePersistenceImpl.Key var1, @NotNull ImmutableList<ClientQueueEntry> var2);
    }
}

