/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.auth;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ClientState;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.handler.PluginAuthenticatorService;
import com.hivemq.mqtt.handler.auth.MqttAuthSender;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.auth.AUTH;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5AuthReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ChannelHandler.Sharable
public class AuthHandler
extends SimpleChannelInboundHandler<AUTH> {
    @VisibleForTesting
    static final String SUCCESS_AUTH_RECEIVED_FROM_CLIENT = "MQTT AUTH packet from client with IP {} provided SUCCESS reason code. Disconnecting client.";
    @VisibleForTesting
    static final String REAUTHENTICATE_DURING_AUTH = "MQTT AUTH packet from client with IP {} provided REAUTHENTICATE reason code during ongoing auth. Disconnecting client.";
    @VisibleForTesting
    static final String REAUTHENTICATE_DURING_RE_AUTH = "MQTT AUTH packet from client with IP {} provided REAUTHENTICATE reason code during ongoing re-auth. Disconnecting client.";
    @NotNull
    private final MqttConnacker connacker;
    @NotNull
    private final MqttAuthSender authSender;
    @NotNull
    private final MqttServerDisconnector disconnector;
    @NotNull
    private final PluginAuthenticatorService authService;

    @Inject
    public AuthHandler(@NotNull MqttConnacker connacker, @NotNull MqttAuthSender authSender, @NotNull MqttServerDisconnector disconnector, @NotNull PluginAuthenticatorService authService) {
        this.connacker = connacker;
        this.authSender = authSender;
        this.disconnector = disconnector;
        this.authService = authService;
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull AUTH msg) {
        Channel channel = ctx.channel();
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        this.authSender.logAuth(channel, (Mqtt5AuthReasonCode)msg.getReasonCode(), true);
        switch ((Mqtt5AuthReasonCode)msg.getReasonCode()) {
            case SUCCESS: {
                this.onReceivedSuccess(ctx, msg, clientConnectionContext);
                break;
            }
            case CONTINUE_AUTHENTICATION: {
                this.onReceivedContinue(ctx, msg, clientConnectionContext);
                break;
            }
            case REAUTHENTICATE: {
                this.onReceivedReAuthenticate(ctx, msg, clientConnectionContext);
            }
        }
    }

    private void onReceivedSuccess(@NotNull ChannelHandlerContext ctx, @NotNull AUTH msg, @NotNull ClientConnectionContext clientConnectionContext) {
        String reasonString = String.format("%s with invalid reason code was sent. This is a protocol violation.", msg.getType().name());
        if (clientConnectionContext.getClientState() == ClientState.RE_AUTHENTICATING) {
            this.disconnector.disconnect(ctx.channel(), SUCCESS_AUTH_RECEIVED_FROM_CLIENT, "Success reason code set in AUTH", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, reasonString, Mqtt5UserProperties.NO_USER_PROPERTIES, true, false);
        } else {
            this.connacker.connackError(ctx.channel(), SUCCESS_AUTH_RECEIVED_FROM_CLIENT, "Success reason code set in AUTH", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, reasonString, Mqtt5UserProperties.NO_USER_PROPERTIES, true);
        }
    }

    private void onReceivedContinue(@NotNull ChannelHandlerContext ctx, @NotNull AUTH msg, @NotNull ClientConnectionContext clientConnectionContext) {
        this.authService.authenticateAuth(ctx, clientConnectionContext, msg);
    }

    private void onReceivedReAuthenticate(@NotNull ChannelHandlerContext ctx, @NotNull AUTH msg, @NotNull ClientConnectionContext clientConnectionContext) {
        ClientState clientState = clientConnectionContext.getClientState();
        if (clientState == ClientState.AUTHENTICATING || clientState == ClientState.RE_AUTHENTICATING) {
            String reasonString = String.format("%s with invalid reason code was sent. This is a protocol violation.", msg.getType().name());
            if (clientState == ClientState.RE_AUTHENTICATING) {
                this.disconnector.disconnect(ctx.channel(), REAUTHENTICATE_DURING_RE_AUTH, "REAUTHENTICATE reason code set in AUTH during ongoing re-auth", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, reasonString, Mqtt5UserProperties.NO_USER_PROPERTIES, true, false);
            } else {
                this.connacker.connackError(ctx.channel(), REAUTHENTICATE_DURING_AUTH, "REAUTHENTICATE reason code set in AUTH during ongoing auth", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, reasonString, Mqtt5UserProperties.NO_USER_PROPERTIES, true);
            }
            return;
        }
        clientConnectionContext.proposeClientState(ClientState.RE_AUTHENTICATING);
        this.authService.authenticateAuth(ctx, clientConnectionContext, msg);
    }
}

