/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.connect;

import com.google.inject.Inject;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.logging.LoggingUtils;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;

public class NoTlsHandshakeIdleHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    @Inject
    public NoTlsHandshakeIdleHandler(@NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            String eventLogMessage = LoggingUtils.appendListenerToMessage(ctx.channel(), "TLS handshake not finished in time");
            this.mqttServerDisconnector.logAndClose(ctx.channel(), "Client with IP {} disconnected. The client was idle for too long without finishing the TLS handshake.", eventLogMessage);
            return;
        }
        super.userEventTriggered(ctx, evt);
    }
}

