/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.publish;

import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.event.PublishDroppedEvent;
import com.hivemq.mqtt.event.PubrelDroppedEvent;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ChannelHandler.Sharable
public class MessageExpiryHandler
extends ChannelOutboundHandlerAdapter {
    static final Logger log = LoggerFactory.getLogger(MessageExpiryHandler.class);

    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) throws Exception {
        if (msg instanceof PUBLISH) {
            boolean drop;
            PUBLISH publish = (PUBLISH)msg;
            this.checkAndSetPublishExpiry(publish);
            boolean expireInflight = InternalConfigurations.EXPIRE_INFLIGHT_MESSAGES_ENABLED;
            boolean isInflight = publish.getQoS() == QoS.EXACTLY_ONCE && publish.isDuplicateDelivery();
            boolean bl = drop = publish.getMessageExpiryInterval() == 0L && (!isInflight || expireInflight);
            if (drop) {
                ctx.fireUserEventTriggered((Object)new PublishDroppedEvent(publish));
                return;
            }
        } else if (msg instanceof PUBREL) {
            boolean drop;
            PUBREL pubrel = (PUBREL)msg;
            this.checkAndSetPubrelExpiry(pubrel);
            boolean expireInflight = InternalConfigurations.EXPIRE_INFLIGHT_PUBRELS_ENABLED;
            boolean bl = drop = pubrel.getMessageExpiryInterval() != null && pubrel.getMessageExpiryInterval() == 0L && expireInflight;
            if (drop) {
                ctx.fireUserEventTriggered((Object)new PubrelDroppedEvent(pubrel));
                return;
            }
        }
        super.write(ctx, msg, promise);
    }

    private void checkAndSetPublishExpiry(@NotNull PUBLISH message) {
        if (message.getMessageExpiryInterval() != 0x100000000L) {
            long waitingInSeconds = (System.currentTimeMillis() - message.getTimestamp()) / 1000L;
            long remainingInterval = Math.max(0L, message.getMessageExpiryInterval() - waitingInSeconds);
            message.setMessageExpiryInterval(remainingInterval);
        }
    }

    private void checkAndSetPubrelExpiry(@NotNull PUBREL message) {
        if (message.getMessageExpiryInterval() == null || message.getPublishTimestamp() == null) {
            return;
        }
        if (message.getMessageExpiryInterval() != 0x100000000L) {
            long waitingInSeconds = (System.currentTimeMillis() - message.getPublishTimestamp()) / 1000L;
            long remainingInterval = Math.max(0L, message.getMessageExpiryInterval() - waitingInSeconds);
            message.setMessageExpiryInterval(remainingInterval);
        }
    }
}

