/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.reason;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.unsuback.UnsubackReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import com.hivemq.mqtt.message.reason.MqttCommonReasonCode;

public enum Mqtt5UnsubAckReasonCode implements Mqtt5ReasonCode
{
    SUCCESS(MqttCommonReasonCode.SUCCESS),
    NO_SUBSCRIPTIONS_EXISTED(17),
    UNSPECIFIED_ERROR(MqttCommonReasonCode.UNSPECIFIED_ERROR),
    IMPLEMENTATION_SPECIFIC_ERROR(MqttCommonReasonCode.IMPLEMENTATION_SPECIFIC_ERROR),
    NOT_AUTHORIZED(MqttCommonReasonCode.NOT_AUTHORIZED),
    TOPIC_FILTER_INVALID(MqttCommonReasonCode.TOPIC_FILTER_INVALID),
    PACKET_IDENTIFIER_IN_USE(MqttCommonReasonCode.PACKET_IDENTIFIER_IN_USE);

    @NotNull
    private static final Mqtt5UnsubAckReasonCode[] VALUES;
    private final int code;
    @NotNull
    private final UnsubackReasonCode unsubackReasonCode;
    @NotNull
    private static final @NotNull Mqtt5UnsubAckReasonCode @NotNull [] UNSUBACK_LOOKUP;

    private Mqtt5UnsubAckReasonCode(int code) {
        this.code = code;
        this.unsubackReasonCode = UnsubackReasonCode.valueOf((String)this.name());
    }

    private Mqtt5UnsubAckReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @NotNull
    public UnsubackReasonCode toUnsubackReasonCode() {
        return this.unsubackReasonCode;
    }

    @Nullable
    public static Mqtt5UnsubAckReasonCode fromCode(int code) {
        for (Mqtt5UnsubAckReasonCode reasonCode : VALUES) {
            if (reasonCode.code != code) continue;
            return reasonCode;
        }
        return null;
    }

    @NotNull
    public static Mqtt5UnsubAckReasonCode from(@NotNull UnsubackReasonCode reasonCode) {
        return UNSUBACK_LOOKUP[reasonCode.ordinal()];
    }

    static {
        VALUES = Mqtt5UnsubAckReasonCode.values();
        UNSUBACK_LOOKUP = new Mqtt5UnsubAckReasonCode[UnsubackReasonCode.values().length];
        Mqtt5UnsubAckReasonCode[] mqtt5UnsubAckReasonCodeArray = Mqtt5UnsubAckReasonCode.values();
        int n = mqtt5UnsubAckReasonCodeArray.length;
        for (int i = 0; i < n; ++i) {
            Mqtt5UnsubAckReasonCode reasonCode;
            Mqtt5UnsubAckReasonCode.UNSUBACK_LOOKUP[reasonCode.unsubackReasonCode.ordinal()] = reasonCode = mqtt5UnsubAckReasonCodeArray[i];
        }
    }
}

