/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic.tree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.ImmutableIntArray;
import com.google.common.util.concurrent.Striped;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.metrics.MetricsHolder;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.mqtt.topic.SubscriberWithIdentifiers;
import com.hivemq.mqtt.topic.SubscriberWithQoS;
import com.hivemq.mqtt.topic.tree.MatchingNodeSubscriptions;
import com.hivemq.mqtt.topic.tree.SubscriptionCounters;
import com.hivemq.mqtt.topic.tree.TopicSubscribers;
import com.hivemq.mqtt.topic.tree.TopicTreeNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalTopicTree {
    private static final Logger log = LoggerFactory.getLogger(LocalTopicTree.class);
    final CopyOnWriteArrayList<SubscriberWithQoS> rootWildcardSubscribers = new CopyOnWriteArrayList();
    @NotNull
    private final Striped<ReadWriteLock> segmentLocks;
    @VisibleForTesting
    final SubscriptionCounters counters;
    @VisibleForTesting
    final ConcurrentHashMap<String, TopicTreeNode> segments = new ConcurrentHashMap();
    private final int mapCreationThreshold;

    @Inject
    public LocalTopicTree(@NotNull MetricsHolder metricsHolder) {
        this.counters = new SubscriptionCounters(metricsHolder.getSubscriptionCounter());
        this.mapCreationThreshold = InternalConfigurations.TOPIC_TREE_MAP_CREATION_THRESHOLD.get();
        this.segmentLocks = Striped.readWriteLock((int)64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTopic(@NotNull String subscriber, @NotNull Topic topic, byte flags, @Nullable String sharedName) {
        Preconditions.checkNotNull((Object)subscriber, (Object)"Subscriber must not be null");
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        String[] contents = StringUtils.splitPreserveAllTokens((String)topic.getTopic(), (char)'/');
        if (contents.length > 1000) {
            log.warn("Subscription from {} on topic {} exceeds maximum segment count of 1000 segments, ignoring it", (Object)subscriber, (Object)topic);
            return false;
        }
        if (contents.length == 0) {
            log.debug("Tried to add an empty topic to the topic tree.");
            return false;
        }
        SubscriberWithQoS entry = new SubscriberWithQoS(subscriber, topic.getQoS().getQosNumber(), flags, sharedName, topic.getSubscriptionIdentifier(), null);
        if (contents.length == 1 && "#".equals(contents[0])) {
            if (!this.rootWildcardSubscribers.contains(entry)) {
                boolean removed = this.removeRootWildcardSubscriber(subscriber, sharedName);
                this.rootWildcardSubscribers.add(entry);
                this.counters.getSubscriptionCounter().inc();
                return removed;
            }
            return true;
        }
        String segmentKey = contents[0];
        Lock lock = ((ReadWriteLock)this.segmentLocks.get((Object)segmentKey)).writeLock();
        lock.lock();
        try {
            TopicTreeNode node = this.segments.get(segmentKey);
            if (node == null) {
                node = new TopicTreeNode(segmentKey);
                this.segments.put(segmentKey, node);
            }
            if (contents.length == 1) {
                boolean bl = node.exactSubscriptions.addSubscriber(entry, topic.getTopic(), this.counters, this.mapCreationThreshold);
                return bl;
            }
            boolean bl = this.addNode(entry, topic.getTopic(), contents, node, 1);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean addNode(@NotNull SubscriberWithQoS subscriber, @NotNull String topicFilter, @NotNull String[] contents, @NotNull TopicTreeNode node, int i) {
        String content = contents[i];
        if ("#".equals(content)) {
            return node.wildcardSubscriptions.addSubscriber(subscriber, topicFilter, this.counters, this.mapCreationThreshold);
        }
        TopicTreeNode subNode = node.addChildNodeIfAbsent(content, this.mapCreationThreshold);
        if (i + 1 == contents.length) {
            return subNode.exactSubscriptions.addSubscriber(subscriber, topicFilter, this.counters, this.mapCreationThreshold);
        }
        return this.addNode(subscriber, topicFilter, contents, subNode, i + 1);
    }

    @NotNull
    public TopicSubscribers findTopicSubscribers(@NotNull String topic) {
        return this.findTopicSubscribers(topic, false);
    }

    @NotNull
    public TopicSubscribers findTopicSubscribers(@NotNull String topic, boolean excludeRootLevelWildcard) {
        ImmutableList.Builder subscribers = ImmutableList.builder();
        ImmutableSet.Builder sharedSubscriptions = ImmutableSet.builder();
        ClientQueueDispatchingSubscriptionInfoFinder subscriberConsumer = new ClientQueueDispatchingSubscriptionInfoFinder((ImmutableList.Builder<SubscriberWithQoS>)subscribers, (ImmutableSet.Builder<String>)sharedSubscriptions);
        this.findSubscribers(topic, excludeRootLevelWildcard, subscriberConsumer);
        ImmutableSet<SubscriberWithIdentifiers> distinctSubscribers = LocalTopicTree.createDistinctSubscribers((ImmutableList<SubscriberWithQoS>)subscribers.build());
        return new TopicSubscribers(distinctSubscribers, (ImmutableSet<String>)sharedSubscriptions.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findSubscribers(@NotNull String topic, boolean excludeRootLevelWildcard, @NotNull SubscriptionsConsumer subscriberAndTopicConsumer) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        if (!excludeRootLevelWildcard) {
            subscriberAndTopicConsumer.acceptRootState(this.rootWildcardSubscribers);
        }
        if (this.segments.isEmpty() || topic.isEmpty()) {
            return;
        }
        String[] topicPart = StringUtils.splitPreserveAllTokens((String)topic, (char)'/');
        String segmentKey = topicPart[0];
        Lock lock = ((ReadWriteLock)this.segmentLocks.get((Object)segmentKey)).readLock();
        lock.lock();
        try {
            TopicTreeNode firstSegmentNode = this.segments.get(segmentKey);
            if (firstSegmentNode != null) {
                LocalTopicTree.traverseTree(firstSegmentNode, subscriberAndTopicConsumer, topicPart, 0);
            }
        }
        finally {
            lock.unlock();
        }
        if (!excludeRootLevelWildcard) {
            Lock wildcardLock = ((ReadWriteLock)this.segmentLocks.get((Object)"+")).readLock();
            wildcardLock.lock();
            try {
                TopicTreeNode firstSegmentNode = this.segments.get("+");
                if (firstSegmentNode != null) {
                    LocalTopicTree.traverseTree(firstSegmentNode, subscriberAndTopicConsumer, topicPart, 0);
                }
            }
            finally {
                wildcardLock.unlock();
            }
        }
    }

    @NotNull
    private static ImmutableSet<SubscriberWithIdentifiers> createDistinctSubscribers(@NotNull ImmutableList<SubscriberWithQoS> subscribers) {
        ImmutableSet.Builder newSet = ImmutableSet.builder();
        ImmutableList subscriberWithQoS = ImmutableList.sortedCopyOf(Comparator.naturalOrder(), subscribers);
        UnmodifiableIterator iterator = subscriberWithQoS.iterator();
        SubscriberWithIdentifiers last = null;
        while (iterator.hasNext()) {
            SubscriberWithQoS current = (SubscriberWithQoS)iterator.next();
            if (last != null) {
                if (!LocalTopicTree.equalSubscription(current, last)) {
                    newSet.add((Object)last);
                    last = new SubscriberWithIdentifiers(current);
                } else {
                    last.setQos(current.getQos());
                    if (current.getSubscriptionIdentifier() != null) {
                        ImmutableIntArray subscriptionIds = last.getSubscriptionIdentifier();
                        Integer subscriptionId = current.getSubscriptionIdentifier();
                        ImmutableIntArray mergedSubscriptionIds = ImmutableIntArray.builder((int)(subscriptionIds.length() + 1)).addAll(subscriptionIds).add(subscriptionId.intValue()).build();
                        last.setSubscriptionIdentifiers(mergedSubscriptionIds);
                    }
                }
            } else {
                last = new SubscriberWithIdentifiers(current);
            }
            if (iterator.hasNext()) continue;
            newSet.add((Object)last);
        }
        return newSet.build();
    }

    private static boolean equalSubscription(@NotNull SubscriberWithQoS first, @NotNull SubscriberWithIdentifiers second) {
        return LocalTopicTree.equalSubscription(first, second.getSubscriber(), second.getTopicFilter(), second.getSharedName());
    }

    private static boolean equalSubscription(@NotNull SubscriberWithQoS first, @NotNull String secondClient, @Nullable String secondTopicFilter, @Nullable String secondSharedName) {
        if (!first.getSubscriber().equals(secondClient)) {
            return false;
        }
        if (!Objects.equals(first.getTopicFilter(), secondTopicFilter)) {
            return false;
        }
        return Objects.equals(first.getSharedName(), secondSharedName);
    }

    private static void traverseTree(@NotNull TopicTreeNode node, @NotNull SubscriptionsConsumer subscriberAndTopicConsumer, String[] topicPart, int depth) {
        boolean end;
        if (!topicPart[depth].equals(node.getTopicPart()) && !"+".equals(node.getTopicPart())) {
            return;
        }
        subscriberAndTopicConsumer.acceptNonRootState(node.wildcardSubscriptions);
        boolean bl = end = topicPart.length - 1 == depth;
        if (end) {
            subscriberAndTopicConsumer.acceptNonRootState(node.exactSubscriptions);
        } else {
            if (LocalTopicTree.getChildrenCount(node) == 0) {
                return;
            }
            int nextDepth = depth + 1;
            if (node.getChildrenMap() != null) {
                TopicTreeNode matchingWildcardNode;
                TopicTreeNode matchingChildNode = LocalTopicTree.getIndexForChildNode(topicPart[nextDepth], node);
                if (matchingChildNode != null) {
                    LocalTopicTree.traverseTree(matchingChildNode, subscriberAndTopicConsumer, topicPart, depth + 1);
                }
                if ((matchingWildcardNode = LocalTopicTree.getIndexForChildNode("+", node)) != null) {
                    LocalTopicTree.traverseTree(matchingWildcardNode, subscriberAndTopicConsumer, topicPart, nextDepth);
                }
                return;
            }
            TopicTreeNode[] children = node.getChildren();
            if (children == null) {
                return;
            }
            for (TopicTreeNode childNode : children) {
                if (childNode == null) continue;
                LocalTopicTree.traverseTree(childNode, subscriberAndTopicConsumer, topicPart, nextDepth);
            }
        }
    }

    @Nullable
    private static TopicTreeNode getIndexForChildNode(@NotNull String key, @NotNull TopicTreeNode node) {
        Map<String, TopicTreeNode> childrenMap = node.getChildrenMap();
        if (childrenMap == null) {
            return null;
        }
        return childrenMap.get(key);
    }

    private boolean removeRootWildcardSubscriber(@NotNull String subscriber, @Nullable String sharedName) {
        ImmutableList.Builder foundSubscribers = ImmutableList.builder();
        for (SubscriberWithQoS rootWildcardSubscriber : this.rootWildcardSubscribers) {
            if (!rootWildcardSubscriber.getSubscriber().equals(subscriber) || !Objects.equals(rootWildcardSubscriber.getSharedName(), sharedName)) continue;
            foundSubscribers.add((Object)rootWildcardSubscriber);
        }
        ImmutableList foundSubscriberList = foundSubscribers.build();
        if (!foundSubscriberList.isEmpty()) {
            this.rootWildcardSubscribers.removeAll((Collection<?>)foundSubscriberList);
            this.counters.getSubscriptionCounter().dec((long)foundSubscriberList.size());
        }
        return !foundSubscriberList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(@NotNull String subscriber, @NotNull String topic, @Nullable String sharedName) {
        Preconditions.checkNotNull((Object)subscriber);
        Preconditions.checkNotNull((Object)topic);
        if ("#".equals(topic)) {
            this.removeRootWildcardSubscriber(subscriber, sharedName);
            return;
        }
        if (this.segments.isEmpty()) {
            return;
        }
        if (topic.isEmpty()) {
            log.debug("Tried to remove an empty topic from the topic tree.");
            return;
        }
        String[] topicPart = StringUtils.splitPreserveAllTokens((String)topic, (String)"/");
        TopicTreeNode[] nodes = new TopicTreeNode[topicPart.length];
        String segmentKey = topicPart[0];
        Lock lock = ((ReadWriteLock)this.segmentLocks.get((Object)segmentKey)).writeLock();
        lock.lock();
        try {
            TopicTreeNode segmentNode = this.segments.get(segmentKey);
            if (segmentNode == null) {
                return;
            }
            if (topicPart.length == 1) {
                segmentNode.exactSubscriptions.removeSubscriber(subscriber, sharedName, topic, this.counters);
            }
            if (topicPart.length == 2 && "#".equals(topicPart[1])) {
                segmentNode.wildcardSubscriptions.removeSubscriber(subscriber, sharedName, topic, this.counters);
            }
            LocalTopicTree.iterateChildNodesForSubscriberRemoval(segmentNode, topicPart, nodes, 0);
            TopicTreeNode lastFoundNode = LocalTopicTree.getLastNode(nodes);
            if (lastFoundNode != null) {
                String lastTopicPart = topicPart[topicPart.length - 1];
                if ("#".equals(lastTopicPart)) {
                    lastFoundNode.wildcardSubscriptions.removeSubscriber(subscriber, sharedName, topic, this.counters);
                } else if (lastTopicPart.equals(lastFoundNode.getTopicPart())) {
                    lastFoundNode.exactSubscriptions.removeSubscriber(subscriber, sharedName, topic, this.counters);
                }
            }
            for (int i = nodes.length - 1; i > 0; --i) {
                TopicTreeNode childOfParent;
                TopicTreeNode[] childrenOfParent;
                TopicTreeNode node = nodes[i];
                if (node == null || !node.isNodeEmpty()) continue;
                TopicTreeNode parent = nodes[i - 1];
                if (parent == null) {
                    parent = segmentNode;
                }
                if ((childrenOfParent = parent.getChildren()) != null) {
                    for (int j = 0; j < childrenOfParent.length; ++j) {
                        if (childrenOfParent[j] != node) continue;
                        childrenOfParent[j] = null;
                    }
                    continue;
                }
                if (parent.getChildrenMap() == null || (childOfParent = parent.getChildrenMap().get(node.getTopicPart())) != node) continue;
                parent.getChildrenMap().remove(childOfParent.getTopicPart());
            }
            if (LocalTopicTree.getChildrenCount(segmentNode) == 0 && segmentNode.exactSubscriptions.getSubscriberCount() == 0 && segmentNode.wildcardSubscriptions.getSubscriberCount() == 0) {
                this.segments.remove(segmentNode.getTopicPart());
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    private static TopicTreeNode getLastNode(@NotNull TopicTreeNode[] nodes) {
        for (int i = nodes.length - 1; i >= 0; --i) {
            TopicTreeNode node = nodes[i];
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private static void iterateChildNodesForSubscriberRemoval(@NotNull TopicTreeNode node, @NotNull String[] topicParts, @NotNull TopicTreeNode[] results, int depth) {
        TopicTreeNode foundNode;
        block5: {
            block4: {
                foundNode = null;
                if (node.getChildrenMap() == null) break block4;
                if (topicParts.length <= depth + 1) break block5;
                TopicTreeNode indexNode = node.getChildrenMap().get(topicParts[depth + 1]);
                if (indexNode == null) {
                    return;
                }
                foundNode = indexNode;
                break block5;
            }
            if (node.getChildren() != null) {
                for (int i = 0; i < node.getChildren().length; ++i) {
                    TopicTreeNode child = node.getChildren()[i];
                    if (child == null || depth + 2 > topicParts.length || !child.getTopicPart().equals(topicParts[depth + 1])) continue;
                    foundNode = child;
                    break;
                }
            }
        }
        if (foundNode != null) {
            results[depth + 1] = foundNode;
            LocalTopicTree.iterateChildNodesForSubscriberRemoval(foundNode, topicParts, results, depth + 1);
        }
    }

    @NotNull
    public ImmutableSet<SubscriberWithQoS> getSharedSubscriber(@NotNull String group, @NotNull String topicFilter) {
        return this.getSubscriptionsByTopicFilter(topicFilter, subscriber -> subscriber.isSharedSubscription() && subscriber.getSharedName() != null && subscriber.getSharedName().equals(group));
    }

    @NotNull
    public ImmutableSet<String> getSubscribersWithFilter(@NotNull String topicFilter, @NotNull Predicate<SubscriberWithQoS> itemFilter) {
        return LocalTopicTree.createDistinctSubscriberIds(this.getSubscriptionsByTopicFilter(topicFilter, itemFilter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableSet<String> getSubscribersForTopic(@NotNull String topic, @NotNull Predicate<SubscriberWithQoS> itemFilter, boolean excludeRootLevelWildcard) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        ImmutableSet.Builder subscribers = ImmutableSet.builder();
        if (!excludeRootLevelWildcard) {
            for (SubscriberWithQoS rootWildcardSubscriber : this.rootWildcardSubscribers) {
                this.addAfterItemCallback(itemFilter, (ImmutableSet.Builder<String>)subscribers, rootWildcardSubscriber);
            }
        }
        if (this.segments.isEmpty() || topic.isEmpty()) {
            return subscribers.build();
        }
        String[] topicPart = StringUtils.splitPreserveAllTokens((String)topic, (char)'/');
        String segmentKey = topicPart[0];
        Lock lock = ((ReadWriteLock)this.segmentLocks.get((Object)segmentKey)).readLock();
        lock.lock();
        try {
            TopicTreeNode firstSegmentNode = this.segments.get(segmentKey);
            if (firstSegmentNode != null) {
                LocalTopicTree.traverseTreeWithFilter(firstSegmentNode, (ImmutableSet.Builder<String>)subscribers, topicPart, 0, itemFilter);
            }
        }
        finally {
            lock.unlock();
        }
        if (!excludeRootLevelWildcard) {
            Lock wildcardLock = ((ReadWriteLock)this.segmentLocks.get((Object)"+")).readLock();
            wildcardLock.lock();
            try {
                TopicTreeNode firstSegmentNode = this.segments.get("+");
                if (firstSegmentNode != null) {
                    LocalTopicTree.traverseTreeWithFilter(firstSegmentNode, (ImmutableSet.Builder<String>)subscribers, topicPart, 0, itemFilter);
                }
            }
            finally {
                wildcardLock.unlock();
            }
        }
        return subscribers.build();
    }

    private static void traverseTreeWithFilter(@NotNull TopicTreeNode node, @NotNull ImmutableSet.Builder<String> subscribers, String[] topicPart, int depth, @NotNull Predicate<SubscriberWithQoS> itemFilter) {
        boolean end;
        if (!topicPart[depth].equals(node.getTopicPart()) && !"+".equals(node.getTopicPart())) {
            return;
        }
        node.wildcardSubscriptions.populateWithSubscriberNamesUsingFilter(itemFilter, subscribers);
        boolean bl = end = topicPart.length - 1 == depth;
        if (end) {
            node.exactSubscriptions.populateWithSubscriberNamesUsingFilter(itemFilter, subscribers);
        } else {
            if (LocalTopicTree.getChildrenCount(node) == 0) {
                return;
            }
            int nextDepth = depth + 1;
            if (node.getChildrenMap() != null) {
                TopicTreeNode matchingWildcardNode;
                TopicTreeNode matchingChildNode = LocalTopicTree.getIndexForChildNode(topicPart[nextDepth], node);
                if (matchingChildNode != null) {
                    LocalTopicTree.traverseTreeWithFilter(matchingChildNode, subscribers, topicPart, nextDepth, itemFilter);
                }
                if ((matchingWildcardNode = LocalTopicTree.getIndexForChildNode("+", node)) != null) {
                    LocalTopicTree.traverseTreeWithFilter(matchingWildcardNode, subscribers, topicPart, nextDepth, itemFilter);
                }
                return;
            }
            TopicTreeNode[] children = node.getChildren();
            if (children == null) {
                return;
            }
            for (TopicTreeNode childNode : children) {
                if (childNode == null) continue;
                LocalTopicTree.traverseTreeWithFilter(childNode, subscribers, topicPart, nextDepth, itemFilter);
            }
        }
    }

    @NotNull
    private static ImmutableSet<String> createDistinctSubscriberIds(ImmutableSet<SubscriberWithQoS> subscriptionsByFilters) {
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)subscriptionsByFilters.size());
        for (SubscriberWithQoS subscription : subscriptionsByFilters) {
            builder.add((Object)subscription.getSubscriber());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ImmutableSet<SubscriberWithQoS> getSubscriptionsByTopicFilter(@NotNull String topicFilter, @NotNull Predicate<SubscriberWithQoS> itemFilter) {
        ImmutableSet.Builder subscribers = ImmutableSet.builder();
        if ("#".equals(topicFilter)) {
            for (SubscriberWithQoS rootWildcardSubscriber : this.rootWildcardSubscribers) {
                this.addAfterCallback(itemFilter, (ImmutableSet.Builder<SubscriberWithQoS>)subscribers, rootWildcardSubscriber);
            }
            return subscribers.build();
        }
        String[] contents = StringUtils.splitPreserveAllTokens((String)topicFilter, (char)'/');
        String firstSegment = contents[0];
        Lock lock = ((ReadWriteLock)this.segmentLocks.get((Object)firstSegment)).readLock();
        lock.lock();
        try {
            Object node = this.segments.get(firstSegment);
            if (node == null) {
                ImmutableSet immutableSet = subscribers.build();
                return immutableSet;
            }
            block7: for (int i = 1; i < contents.length && !"#".equals(contents[i]); ++i) {
                if (((TopicTreeNode)node).getChildren() == null && ((TopicTreeNode)node).getChildrenMap() == null) {
                    ImmutableSet immutableSet = subscribers.build();
                    return immutableSet;
                }
                ImmutableSet children = ((TopicTreeNode)node).getChildren();
                if (children != null) {
                    for (Object child : children) {
                        if (child == null || !((TopicTreeNode)child).getTopicPart().equals(contents[i])) continue;
                        node = child;
                        continue block7;
                    }
                } else if (((TopicTreeNode)node).getChildrenMap() != null) {
                    for (TopicTreeNode child : ((TopicTreeNode)node).getChildrenMap().values()) {
                        if (child == null || !child.getTopicPart().equals(contents[i])) continue;
                        node = child;
                        continue block7;
                    }
                }
                ImmutableSet immutableSet = subscribers.build();
                return immutableSet;
            }
            if ("#".equals(contents[contents.length - 1])) {
                ((TopicTreeNode)node).wildcardSubscriptions.populateWithSubscribersUsingFilter(itemFilter, (ImmutableSet.Builder<SubscriberWithQoS>)subscribers);
            } else {
                ((TopicTreeNode)node).exactSubscriptions.populateWithSubscribersUsingFilter(itemFilter, (ImmutableSet.Builder<SubscriberWithQoS>)subscribers);
            }
            ImmutableSet immutableSet = subscribers.build();
            return immutableSet;
        }
        finally {
            lock.unlock();
        }
    }

    private void addAfterCallback(@NotNull Predicate<SubscriberWithQoS> itemFilter, @NotNull ImmutableSet.Builder<SubscriberWithQoS> subscribers, @Nullable SubscriberWithQoS subscriber) {
        if (subscriber != null && itemFilter.test(subscriber)) {
            subscribers.add((Object)subscriber);
        }
    }

    private void addAfterItemCallback(@NotNull Predicate<SubscriberWithQoS> itemFilter, @NotNull ImmutableSet.Builder<String> subscribers, @Nullable SubscriberWithQoS subscriber) {
        if (subscriber != null && itemFilter.test(subscriber)) {
            subscribers.add((Object)subscriber.getSubscriber());
        }
    }

    @Nullable
    public SubscriberWithIdentifiers findSubscriber(@NotNull String client, @NotNull String topic) {
        ClientPublishDeliverySubscriptionInfoFinder subscriberConsumer = new ClientPublishDeliverySubscriptionInfoFinder(client);
        this.findSubscribers(topic, false, subscriberConsumer);
        return subscriberConsumer.getMatchingSubscriber();
    }

    public static int getChildrenCount(@NotNull TopicTreeNode node) {
        Preconditions.checkNotNull((Object)node, (Object)"Node must not be null");
        if (node.childrenMap != null) {
            return node.childrenMap.size();
        }
        TopicTreeNode[] children = node.getChildren();
        if (children == null) {
            return 0;
        }
        int count = 0;
        for (TopicTreeNode child : children) {
            if (child == null) continue;
            ++count;
        }
        return count;
    }

    private static final class ClientPublishDeliverySubscriptionInfoFinder
    implements SubscriptionsConsumer {
        @NotNull
        private final String client;
        @Nullable
        private SubscriberWithIdentifiers sharedSubscriber;
        @NotNull
        private final ImmutableList.Builder<SubscriberWithQoS> subscribers = ImmutableList.builder();
        private boolean nonSharedSubscriberFound;

        private ClientPublishDeliverySubscriptionInfoFinder(@NotNull String client) {
            this.client = client;
        }

        @Override
        public void acceptNonRootState(@NotNull MatchingNodeSubscriptions matchingNodeSubscriptions) {
            Stream<SubscriberWithQoS> nonSharedSubscriptions = matchingNodeSubscriptions.getNonSharedSubscriptionsStream();
            if (nonSharedSubscriptions != null) {
                nonSharedSubscriptions.filter(subscriberWithQoS -> subscriberWithQoS.getSubscriber().equals(this.client)).forEach(subscriberWithQoS -> {
                    this.subscribers.add(subscriberWithQoS);
                    this.nonSharedSubscriberFound = true;
                });
            }
            matchingNodeSubscriptions.getSharedSubscriptionsStream().filter(subscriberWithQoS -> subscriberWithQoS.getSubscriber().equals(this.client)).forEach(subscriberWithQoS -> {
                if (this.sharedSubscriber == null || this.sharedSubscriber.getQos() < subscriberWithQoS.getQos()) {
                    this.sharedSubscriber = new SubscriberWithIdentifiers((SubscriberWithQoS)subscriberWithQoS);
                }
            });
        }

        @Override
        public void acceptRootState(@NotNull List<SubscriberWithQoS> rootWildcardSubscriptions) {
            for (SubscriberWithQoS rootWildcardSubscriber : rootWildcardSubscriptions) {
                if (!rootWildcardSubscriber.getSubscriber().equals(this.client)) continue;
                if (!rootWildcardSubscriber.isSharedSubscription()) {
                    this.subscribers.add((Object)rootWildcardSubscriber);
                    this.nonSharedSubscriberFound = true;
                    continue;
                }
                if (this.nonSharedSubscriberFound || this.sharedSubscriber != null && this.sharedSubscriber.getQos() >= rootWildcardSubscriber.getQos()) continue;
                this.sharedSubscriber = new SubscriberWithIdentifiers(rootWildcardSubscriber);
            }
        }

        @Nullable
        public SubscriberWithIdentifiers getMatchingSubscriber() {
            ImmutableList subscribers = this.subscribers.build();
            if (subscribers.isEmpty()) {
                return this.sharedSubscriber;
            }
            ImmutableSet<SubscriberWithIdentifiers> distinctSubscribers = LocalTopicTree.createDistinctSubscribers((ImmutableList<SubscriberWithQoS>)subscribers);
            return (SubscriberWithIdentifiers)distinctSubscribers.asList().get(0);
        }
    }

    static class ClientQueueDispatchingSubscriptionInfoFinder
    implements SubscriptionsConsumer {
        @NotNull
        private final ImmutableList.Builder<SubscriberWithQoS> subscribersBuilder;
        @NotNull
        private final ImmutableSet.Builder<String> sharedSubscriptionsBuilder;

        ClientQueueDispatchingSubscriptionInfoFinder(@NotNull ImmutableList.Builder<SubscriberWithQoS> subscribersBuilder, @NotNull ImmutableSet.Builder<String> sharedSubscriptionsBuilder) {
            this.subscribersBuilder = subscribersBuilder;
            this.sharedSubscriptionsBuilder = sharedSubscriptionsBuilder;
        }

        @Override
        public void acceptNonRootState(@NotNull MatchingNodeSubscriptions matchingNodeSubscriptions) {
            this.sharedSubscriptionsBuilder.addAll(matchingNodeSubscriptions.sharedSubscribersMap.keySet());
            if (matchingNodeSubscriptions.nonSharedSubscribersMap != null) {
                this.subscribersBuilder.addAll(matchingNodeSubscriptions.nonSharedSubscribersMap.values());
            } else if (matchingNodeSubscriptions.nonSharedSubscribersArray != null) {
                for (SubscriberWithQoS exactSubscriber : matchingNodeSubscriptions.nonSharedSubscribersArray) {
                    if (exactSubscriber == null) continue;
                    this.subscribersBuilder.add((Object)exactSubscriber);
                }
            }
        }

        @Override
        public void acceptRootState(@NotNull List<SubscriberWithQoS> rootWildcardSubscriptions) {
            for (SubscriberWithQoS rootWildcardSubscriber : rootWildcardSubscriptions) {
                if (rootWildcardSubscriber.isSharedSubscription()) {
                    this.sharedSubscriptionsBuilder.add((Object)(rootWildcardSubscriber.getSharedName() + "/#"));
                    continue;
                }
                this.subscribersBuilder.add((Object)rootWildcardSubscriber);
            }
        }
    }

    static interface SubscriptionsConsumer {
        public void acceptNonRootState(@NotNull MatchingNodeSubscriptions var1);

        public void acceptRootState(@NotNull List<SubscriberWithQoS> var1);
    }
}

