/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.clientqueue;

import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.MessageWithID;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.PropertiesSerializationUtil;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.publish.PUBLISHFactory;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.persistence.clientqueue.ClientQueuePersistenceImpl;
import com.hivemq.persistence.local.xodus.XodusUtils;
import com.hivemq.util.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.ByteIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientQueuePersistenceSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientQueuePersistenceSerializer.class);
    static final int NO_PACKET_ID = 0;
    static final int CLIENT_ID_MATCH = 0;
    static final int CLIENT_ID_SAME_PREFIX = 1;
    static final int CLIENT_ID_NO_MATCH = 2;
    private static final byte PUBLISH_BIT = -128;
    private static final byte PUBREL_BIT = 64;
    private static final byte RETAINED_BIT = 32;
    private static final byte DUPLICATE_DELIVERY_BIT = 16;
    private static final byte RETAINED_MESSAGE_BIT = 4;
    private static final byte QOS_BITS = 3;
    private static final byte RESPONSE_TOPIC_PRESENT_BIT = -128;
    private static final byte CONTENT_TYPE_PRESENT_BIT = 64;
    private static final byte CORRELATION_DATA_PRESENT_BIT = 32;
    private static final byte SUBSCRIPTION_IDENTIFIERS_PRESENT_BIT = 16;
    private static final byte USER_PROPERTIES_PRESENT_BIT = 8;
    public static final AtomicLong NEXT_PUBLISH_NUMBER = new AtomicLong(0x3FFFFFFFFFFFFFFFL);

    @NotNull
    ByteIterable serializeNewPublishKey(@NotNull ClientQueuePersistenceImpl.Key key) {
        return this.serializeKey(key, NEXT_PUBLISH_NUMBER.getAndIncrement());
    }

    @NotNull
    ByteIterable serializeUnknownPubRelKey(@NotNull ClientQueuePersistenceImpl.Key key) {
        long messageNumber = NEXT_PUBLISH_NUMBER.getAndIncrement() - 0x3FFFFFFFFFFFFFFFL;
        return this.serializeKey(key, messageNumber);
    }

    @NotNull
    ByteIterable serializeKey(@NotNull ClientQueuePersistenceImpl.Key key, long number) {
        byte[] clientBytes = key.getQueueId().getBytes(StandardCharsets.UTF_8);
        byte[] result = new byte[clientBytes.length + 1 + 8];
        System.arraycopy(clientBytes, 0, result, 0, clientBytes.length);
        result[clientBytes.length] = (byte)(key.isShared() ? 1 : 0);
        Bytes.copyLongToByteArray(number, result, clientBytes.length + 1);
        return XodusUtils.bytesToByteIterable(result);
    }

    @NotNull
    ByteIterable serializeKey(@NotNull ClientQueuePersistenceImpl.Key key) {
        byte[] clientBytes = key.getQueueId().getBytes(StandardCharsets.UTF_8);
        byte[] result = new byte[clientBytes.length + 1];
        System.arraycopy(clientBytes, 0, result, 0, clientBytes.length);
        result[clientBytes.length] = (byte)(key.isShared() ? 1 : 0);
        return XodusUtils.bytesToByteIterable(result);
    }

    int compareClientId(@NotNull ByteIterable serializedClientId, @NotNull ByteIterable serializedKey) {
        int clientLength = serializedClientId.getLength();
        if (serializedClientId.compareTo((Object)serializedKey.subIterable(0, clientLength)) != 0) {
            return 2;
        }
        if (clientLength == serializedKey.getLength() - 8) {
            return 0;
        }
        return 1;
    }

    @NotNull
    ClientQueuePersistenceImpl.Key deserializeKeyId(@NotNull ByteIterable serializedKey) {
        byte[] bytes = serializedKey.getBytesUnsafe();
        int clientIdLength = serializedKey.getLength() - 1 - 8;
        String client = new String(bytes, 0, clientIdLength, StandardCharsets.UTF_8);
        boolean shared = bytes[clientIdLength] == 1;
        return new ClientQueuePersistenceImpl.Key(client, shared);
    }

    long deserializeIndex(@NotNull ByteIterable serializedKey) {
        byte[] keyBytes = XodusUtils.byteIterableToBytes(serializedKey);
        int indexIndex = serializedKey.getLength() - 8;
        return Bytes.readLong(keyBytes, indexIndex);
    }

    @NotNull
    ByteIterable serializePublishWithoutPacketId(@NotNull PUBLISH publish, boolean retained) {
        return XodusUtils.bytesToByteIterable(this.createPublishBytes(publish, retained));
    }

    @NotNull
    ByteIterable serializeAndSetPacketId(@NotNull ByteIterable serializedValue, int packetId) {
        byte[] bytes = XodusUtils.byteIterableToBytes(serializedValue);
        Bytes.copyUnsignedShortToByteArray(packetId, bytes, 0);
        return XodusUtils.bytesToByteIterable(bytes);
    }

    @NotNull
    ByteIterable serializePubRel(@NotNull PUBREL pubrel, boolean retained) {
        return XodusUtils.bytesToByteIterable(this.createPubrelBytes(pubrel.getPacketIdentifier(), retained, pubrel.getMessageExpiryInterval(), pubrel.getPublishTimestamp()));
    }

    int deserializePacketId(@NotNull ByteIterable serializedValue) {
        return Bytes.readUnsignedShort(serializedValue.getBytesUnsafe(), 0);
    }

    @NotNull
    MessageWithID deserializeValue(@NotNull ByteIterable serializedValue) {
        byte[] bytes = serializedValue.getBytesUnsafe();
        if ((bytes[2] & 0x40) == 64) {
            int packetId = Bytes.readUnsignedShort(bytes, 0);
            PUBREL pubrel = new PUBREL(packetId);
            if (serializedValue.getLength() >= 19) {
                long expiry = Bytes.readLong(bytes, 3);
                pubrel.setMessageExpiryInterval(expiry);
                long timestamp = Bytes.readLong(bytes, 11);
                pubrel.setPublishTimestamp(timestamp);
            }
            return pubrel;
        }
        if ((bytes[2] & 0xFFFFFF80) == -128) {
            return this.deserializePublish(bytes);
        }
        LOGGER.error("Could not deserialize client queue persistence value");
        throw new IllegalArgumentException("Invalid client queue persistence value to deserialize");
    }

    boolean deserializeRetained(@NotNull ByteIterable serializedValue) {
        byte[] bytes = serializedValue.getBytesUnsafe();
        return (bytes[2] & 4) == 4;
    }

    private byte @NotNull [] createPubrelBytes(int packetId, boolean retained, @Nullable Long expiry, @Nullable Long publishTimestamp) {
        byte[] result = expiry != null && publishTimestamp != null ? new byte[19] : new byte[3];
        int cursor = 0;
        cursor = XodusUtils.serializeShort(packetId, result, cursor);
        result[cursor] = 64;
        if (retained) {
            int n = cursor;
            result[n] = (byte)(result[n] | 4);
        }
        ++cursor;
        if (expiry != null && publishTimestamp != null) {
            cursor = XodusUtils.serializeLong(expiry, result, cursor);
            cursor = XodusUtils.serializeLong(publishTimestamp, result, cursor);
        }
        return result;
    }

    private byte @NotNull [] createPublishBytes(@NotNull PUBLISH message, boolean retained) {
        byte[] topic = message.getTopic().getBytes(StandardCharsets.UTF_8);
        byte[] hivemqId = message.getHivemqId().getBytes(StandardCharsets.UTF_8);
        byte[] responseTopic = message.getResponseTopic() == null ? null : message.getResponseTopic().getBytes(StandardCharsets.UTF_8);
        byte[] contentType = message.getContentType() == null ? null : message.getContentType().getBytes(StandardCharsets.UTF_8);
        byte[] correlationData = message.getCorrelationData();
        ImmutableIntArray subscriptionIdentifiers = message.getSubscriptionIdentifiers();
        int subscriptionIdentifierLength = subscriptionIdentifiers == null ? 0 : subscriptionIdentifiers.length();
        int payloadFormatIndicator = message.getPayloadFormatIndicator() != null ? message.getPayloadFormatIndicator().getCode() : -1;
        Mqtt5UserProperties userProperties = message.getUserProperties();
        byte[] result = new byte[4 + XodusUtils.shortLengthArraySize(topic) + 8 + 8 + XodusUtils.shortLengthArraySize(hivemqId) + 8 + 8 + (responseTopic == null ? 0 : XodusUtils.shortLengthArraySize(responseTopic)) + (contentType == null ? 0 : XodusUtils.shortLengthArraySize(contentType)) + (correlationData == null ? 0 : XodusUtils.shortLengthArraySize(correlationData)) + (subscriptionIdentifiers == null ? 0 : 4 + subscriptionIdentifierLength * 4) + 1 + (userProperties.asList().size() == 0 ? 0 : PropertiesSerializationUtil.encodedSize(userProperties))];
        int cursor = 0;
        cursor = XodusUtils.serializeShort(0, result, cursor);
        byte flags = -128;
        flags = (byte)(flags | message.getQoS().getQosNumber());
        if (message.isDuplicateDelivery()) {
            flags = (byte)(flags | 0x10);
        }
        if (message.isRetain()) {
            flags = (byte)(flags | 0x20);
        }
        if (retained) {
            flags = (byte)(flags | 4);
        }
        cursor = XodusUtils.serializeByte(flags, result, cursor);
        byte presentFlags = 0;
        if (responseTopic != null) {
            presentFlags = (byte)(presentFlags | 0xFFFFFF80);
        }
        if (contentType != null) {
            presentFlags = (byte)(presentFlags | 0x40);
        }
        if (correlationData != null) {
            presentFlags = (byte)(presentFlags | 0x20);
        }
        if (subscriptionIdentifiers != null) {
            presentFlags = (byte)(presentFlags | 0x10);
        }
        if (userProperties.asList().size() > 0) {
            presentFlags = (byte)(presentFlags | 8);
        }
        cursor = XodusUtils.serializeByte(presentFlags, result, cursor);
        cursor = XodusUtils.serializeShortLengthArray(topic, result, cursor);
        cursor = XodusUtils.serializeLong(message.getTimestamp(), result, cursor);
        cursor = XodusUtils.serializeLong(message.getPublishId(), result, cursor);
        cursor = XodusUtils.serializeShortLengthArray(hivemqId, result, cursor);
        cursor = XodusUtils.serializeLong(message.getMessageExpiryInterval(), result, cursor);
        if (responseTopic != null) {
            cursor = XodusUtils.serializeShortLengthArray(responseTopic, result, cursor);
        }
        if (contentType != null) {
            cursor = XodusUtils.serializeShortLengthArray(contentType, result, cursor);
        }
        if (correlationData != null) {
            cursor = XodusUtils.serializeShortLengthArray(correlationData, result, cursor);
        }
        if (subscriptionIdentifiers != null) {
            Bytes.copyIntToByteArray(subscriptionIdentifierLength, result, cursor);
            cursor += 4;
            if (subscriptionIdentifierLength > 0) {
                for (int i = 0; i < subscriptionIdentifiers.length(); ++i) {
                    Bytes.copyIntToByteArray(subscriptionIdentifiers.get(i), result, cursor);
                    cursor += 4;
                }
            }
        }
        cursor = XodusUtils.serializeByte((byte)payloadFormatIndicator, result, cursor);
        if (userProperties.asList().size() > 0) {
            PropertiesSerializationUtil.write(userProperties, result, cursor);
        }
        return result;
    }

    @NotNull
    private PUBLISH deserializePublish(@NotNull byte[] serialized) {
        PUBLISHFactory.Mqtt5Builder builder = new PUBLISHFactory.Mqtt5Builder();
        int cursor = 0;
        builder.withPacketIdentifier(Bytes.readUnsignedShort(serialized, cursor));
        builder.withQoS(QoS.valueOf(serialized[cursor += 2] & 3));
        builder.withOnwardQos(QoS.valueOf(serialized[cursor] & 3));
        builder.withDuplicateDelivery((serialized[cursor] & 0x10) == 16);
        builder.withRetain((serialized[cursor] & 0x20) == 32);
        boolean responseTopicPresent = (serialized[++cursor] & 0xFFFFFF80) == -128;
        boolean contentTypePresent = (serialized[cursor] & 0x40) == 64;
        boolean correlationDataPresent = (serialized[cursor] & 0x20) == 32;
        boolean subscriptionIndetifiersPresent = (serialized[cursor] & 0x10) == 16;
        boolean userPropertiesPresent = (serialized[cursor] & 8) == 8;
        int topicLength = Bytes.readUnsignedShort(serialized, ++cursor);
        builder.withTopic(new String(serialized, cursor += 2, topicLength, StandardCharsets.UTF_8));
        builder.withTimestamp(Bytes.readLong(serialized, cursor += topicLength));
        builder.withPublishId(Bytes.readLong(serialized, cursor += 8));
        int hivemqIdLength = Bytes.readUnsignedShort(serialized, cursor += 8);
        builder.withHivemqId(new String(serialized, cursor += 2, hivemqIdLength, StandardCharsets.UTF_8));
        builder.withMessageExpiryInterval(Bytes.readLong(serialized, cursor += hivemqIdLength));
        cursor += 8;
        if (responseTopicPresent) {
            int responseTopicLength = Bytes.readUnsignedShort(serialized, cursor);
            cursor += 2;
            if (responseTopicLength != 0) {
                builder.withResponseTopic(new String(serialized, cursor, responseTopicLength, StandardCharsets.UTF_8));
                cursor += responseTopicLength;
            }
        }
        if (contentTypePresent) {
            int contentTypeLength = Bytes.readUnsignedShort(serialized, cursor);
            cursor += 2;
            if (contentTypeLength != 0) {
                builder.withContentType(new String(serialized, cursor, contentTypeLength, StandardCharsets.UTF_8));
                cursor += contentTypeLength;
            }
        }
        if (correlationDataPresent) {
            int correlationDataLength = Bytes.readUnsignedShort(serialized, cursor);
            cursor += 2;
            if (correlationDataLength != 0) {
                byte[] correlationData = new byte[correlationDataLength];
                System.arraycopy(serialized, cursor, correlationData, 0, correlationDataLength);
                builder.withCorrelationData(correlationData);
                cursor += correlationDataLength;
            }
        }
        if (subscriptionIndetifiersPresent) {
            int subscriptionIdentifiersLength = Bytes.readInt(serialized, cursor);
            cursor += 4;
            ImmutableIntArray.Builder subscriptionIdentifiers = ImmutableIntArray.builder();
            for (int i = 0; i < subscriptionIdentifiersLength; ++i) {
                subscriptionIdentifiers.add(Bytes.readInt(serialized, cursor));
                cursor += 4;
            }
            builder.withSubscriptionIdentifiers(subscriptionIdentifiers.build());
        }
        builder.withPayloadFormatIndicator(Mqtt5PayloadFormatIndicator.fromCode(serialized[cursor]));
        ++cursor;
        if (userPropertiesPresent) {
            builder.withUserProperties(PropertiesSerializationUtil.read(serialized, cursor));
        }
        return builder.build();
    }
}

