/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.clientsession;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.mqtt.topic.SubscriberWithQoS;
import com.hivemq.mqtt.topic.SubscriptionFlag;
import com.hivemq.mqtt.topic.tree.LocalTopicTree;
import com.hivemq.persistence.clientsession.Subscription;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

@LazySingleton
@ThreadSafe
public class SharedSubscriptionService {
    private static final String SHARED_SUBSCRIPTION_PREFIX = "$share/";
    private static final Pattern SHARED_SUBSCRIPTION_PATTERN = Pattern.compile("\\$share(/(.*?)/(.*))");
    private static final int GROUP_INDEX = 2;
    private static final int TOPIC_INDEX = 3;
    @NotNull
    private final LocalTopicTree topicTree;
    @Nullable
    private Cache<String, ImmutableSet<SubscriberWithQoS>> sharedSubscriberCache;
    @Nullable
    private Cache<String, ImmutableSet<Topic>> sharedSubscriptionCache;

    @Inject
    public SharedSubscriptionService(@NotNull LocalTopicTree topicTree) {
        this.topicTree = topicTree;
    }

    private static Matcher getSharedSubscriptionMatcher(@NotNull String topic) {
        return SHARED_SUBSCRIPTION_PATTERN.matcher(topic);
    }

    @PostConstruct
    void postConstruct() {
        this.sharedSubscriberCache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).concurrencyLevel(InternalConfigurations.SHARED_SUBSCRIBER_CACHE_CONCURRENCY_LEVEL.get()).maximumSize(10000L).recordStats().build();
        this.sharedSubscriptionCache = CacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).concurrencyLevel(InternalConfigurations.SHARED_SUBSCRIPTION_CACHE_CONCURRENCY_LEVEL.get()).maximumSize(10000L).recordStats().build();
    }

    @Nullable
    public static SharedSubscription checkForSharedSubscription(@NotNull String topic) {
        Matcher matcher = SharedSubscriptionService.getSharedSubscriptionMatcher(topic);
        if (matcher.matches()) {
            String shareGroup = matcher.group(2);
            String subscriptionTopic = matcher.group(3);
            return new SharedSubscription(subscriptionTopic, shareGroup);
        }
        return null;
    }

    @NotNull
    public Subscription createSubscription(@NotNull Topic topic) {
        SharedSubscription sharedSubscription = SharedSubscriptionService.checkForSharedSubscription(topic.getTopic());
        if (sharedSubscription == null) {
            return new Subscription(topic, SubscriptionFlag.getDefaultFlags(false, topic.isRetainAsPublished(), topic.isNoLocal()), null);
        }
        return new Subscription(new Topic(sharedSubscription.getTopicFilter(), topic.getQoS(), topic.isNoLocal(), topic.isRetainAsPublished(), topic.getRetainHandling(), topic.getSubscriptionIdentifier()), SubscriptionFlag.getDefaultFlags(true, topic.isRetainAsPublished(), topic.isNoLocal()), sharedSubscription.getShareName());
    }

    @NotNull
    public ImmutableSet<SubscriberWithQoS> getSharedSubscriber(@NotNull String sharedSubscription) {
        if (this.sharedSubscriberCache == null) {
            return ImmutableSet.of();
        }
        try {
            return (ImmutableSet)this.sharedSubscriberCache.get((Object)sharedSubscription, () -> {
                SharedSubscription split = SharedSubscriptionService.splitTopicAndGroup(sharedSubscription);
                return this.topicTree.getSharedSubscriber(split.getShareName(), split.getTopicFilter());
            });
        }
        catch (ExecutionException e) {
            return ImmutableSet.of();
        }
    }

    @NotNull
    public ImmutableSet<Topic> getSharedSubscriptions(@NotNull String client, @NotNull Callable cacheUpdater) throws ExecutionException {
        if (this.sharedSubscriptionCache == null) {
            return ImmutableSet.of();
        }
        return (ImmutableSet)this.sharedSubscriptionCache.get((Object)client, cacheUpdater);
    }

    @NotNull
    public static SharedSubscription splitTopicAndGroup(@NotNull String sharedSubscription) {
        int slashIndex = sharedSubscription.indexOf("/");
        String group = sharedSubscription.substring(0, slashIndex);
        String topicFilter = sharedSubscription.substring(slashIndex + 1);
        return new SharedSubscription(topicFilter, group);
    }

    public void invalidateSharedSubscriberCache(@NotNull String sharedSubscription) {
        if (this.sharedSubscriberCache != null) {
            this.sharedSubscriberCache.invalidate((Object)sharedSubscription);
        }
    }

    public void invalidateSharedSubscriptionCache(@NotNull String clientId) {
        if (this.sharedSubscriptionCache != null) {
            this.sharedSubscriptionCache.invalidate((Object)clientId);
        }
    }

    @NotNull
    public static String removePrefix(@NotNull String topic) {
        if (topic.startsWith(SHARED_SUBSCRIPTION_PREFIX)) {
            return topic.substring(SHARED_SUBSCRIPTION_PREFIX.length());
        }
        return topic;
    }

    public static class SharedSubscription {
        @NotNull
        private final String topicFilter;
        @NotNull
        private final String shareName;

        public SharedSubscription(@NotNull String topic, @NotNull String shareName) {
            this.topicFilter = topic;
            this.shareName = shareName;
        }

        @NotNull
        public String getTopicFilter() {
            return this.topicFilter;
        }

        @NotNull
        public String getShareName() {
            return this.shareName;
        }
    }
}

