/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.MessageWithID;
import com.hivemq.persistence.local.IncomingMessageFlowLocalPersistence;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@LazySingleton
public class IncomingMessageFlowInMemoryLocalPersistence
implements IncomingMessageFlowLocalPersistence {
    private final ConcurrentHashMap<MessageFlowKey, MessageWithID> backingMap = new ConcurrentHashMap();

    @Override
    public void closeDB() {
    }

    @Override
    @Nullable
    public MessageWithID get(@NotNull String client, int messageId) {
        return this.backingMap.get(new MessageFlowKey(client, messageId));
    }

    @Override
    public void addOrReplace(@NotNull String client, int messageId, @NotNull MessageWithID message) {
        this.backingMap.put(new MessageFlowKey(client, messageId), message);
    }

    @Override
    public void remove(@NotNull String client, int messageId) {
        this.backingMap.remove(new MessageFlowKey(client, messageId));
    }

    @Override
    public void delete(@NotNull String client) {
        Set keys = this.backingMap.keySet();
        for (MessageFlowKey messageFlowKey : keys) {
            if (!messageFlowKey.getClientId().equals(client)) continue;
            keys.remove(messageFlowKey);
        }
    }

    static class MessageFlowKey {
        private final String clientId;
        private final int messageId;

        public MessageFlowKey(@NotNull String clientId, int messageId) {
            this.clientId = clientId;
            this.messageId = messageId;
        }

        public String getClientId() {
            return this.clientId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageFlowKey that = (MessageFlowKey)o;
            if (this.messageId != that.messageId) {
                return false;
            }
            return this.clientId.equals(that.clientId);
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = 31 * result + this.messageId;
            return result;
        }
    }
}

