/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.xodus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentCloser {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentCloser.class);
    @NotNull
    private final String name;
    @NotNull
    private final Environment environment;
    private final int maxTries;
    private final int retryInterval;
    private int tryNo;

    public EnvironmentCloser(@NotNull String name, @NotNull Environment environment, int maxTries, int retryInterval) {
        Preconditions.checkNotNull((Object)name, (Object)"Name must not be null");
        Preconditions.checkNotNull((Object)environment, (Object)"Environment must not be null");
        Preconditions.checkArgument((maxTries > 0 ? 1 : 0) != 0, (String)"maxTries must be higher than 0. %s was provided", (int)maxTries);
        Preconditions.checkArgument((retryInterval > 0 ? 1 : 0) != 0, (String)"retryInterval must be higher than 0. %s was provided", (int)retryInterval);
        this.name = name;
        this.environment = environment;
        this.maxTries = maxTries;
        this.retryInterval = retryInterval;
    }

    public boolean close() {
        try {
            if (!this.environment.isOpen()) {
                log.warn("Tried to close store {} although it is already closed", (Object)this.name);
                return false;
            }
            if (this.tryNo < this.maxTries) {
                this.environment.close();
                return true;
            }
            log.error("Could not close store {} after {} tries.", (Object)this.name, (Object)this.tryNo);
            return false;
        }
        catch (ExodusException e) {
            return this.retry(e);
        }
    }

    private boolean retry(@NotNull ExodusException e) {
        if ("Finish all transactions before closing database environment".equals(e.getMessage())) {
            ++this.tryNo;
            log.debug("Could not close {}, transactions still aren't finished yet. Retrying again in {}ms (Retry {} of {})", new Object[]{this.name, this.retryInterval, this.tryNo, this.maxTries});
            try {
                Thread.sleep(this.retryInterval);
                return this.close();
            }
            catch (InterruptedException interruptedException) {
                log.debug("Interrupted Exception when trying to close {}", (Object)this.name, (Object)interruptedException);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        throw e;
    }

    @VisibleForTesting
    int getTryNo() {
        return this.tryNo;
    }
}

