/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.payload;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadRocksDBLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadXodusLocalPersistence;
import javax.inject.Inject;
import javax.inject.Provider;

@LazySingleton
public class PublishPayloadLocalPersistenceProvider
implements Provider<PublishPayloadLocalPersistence> {
    @NotNull
    private final Provider<PublishPayloadRocksDBLocalPersistence> rocksDBProvider;
    @NotNull
    private final Provider<PublishPayloadXodusLocalPersistence> xodusProvider;
    @NotNull
    private final PersistenceType persistenceType;

    @Inject
    public PublishPayloadLocalPersistenceProvider(@NotNull Provider<PublishPayloadRocksDBLocalPersistence> rocksDBProvider, @NotNull Provider<PublishPayloadXodusLocalPersistence> xodusProvider) {
        this.rocksDBProvider = rocksDBProvider;
        this.xodusProvider = xodusProvider;
        this.persistenceType = InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get();
    }

    @NotNull
    public PublishPayloadLocalPersistence get() {
        if (this.persistenceType == PersistenceType.FILE_NATIVE) {
            return (PublishPayloadLocalPersistence)this.rocksDBProvider.get();
        }
        return (PublishPayloadLocalPersistence)this.xodusProvider.get();
    }
}

